<?php

namespace FiloBlu\Inboundflow\Controller\Adminhtml\Inboundflow;
use Exception;
use Magento\Backend\App\Action;
use Magento\Framework\View\Result\PageFactory;

/**
 * Class MassMeta
 * @package FiloBlu\Inboundflow\Controller\Adminhtml\Inboundflow
 */
class MassMeta extends Action
{
    /**
     * @var PageFactory
     */
    public function execute()
    {
        $ids = $this->getRequest()->getParam('id');
        $status = $this->getRequest()->getParam('status');
        $flow = urldecode($this->getRequest()->getParam('flow'));
        if (!is_array($ids) || empty($ids)) {
            $this->messageManager->addError(__('Please select product(s).'));
        } else {
            try {
                foreach ($ids as $id) {
                    $row = $this->_objectManager->get('FiloBlu\Flow\Model\Inboundflow' . "\\" . $flow)->load($id);
                    $row->setData('meta_processed', $status)
                        ->save();
                }
                $this->messageManager->addSuccess(
                    __('A total of %1 record(s) have been deleted.', count($ids))
                );
            } catch (Exception $e) {
                $this->messageManager->addError($e->getMessage());
            }
        }
        //$this->_redirect('*/*/');
    }
}
