<?php

namespace FiloBlu\Flow\Controller\Adminhtml\Inboundflow;

use Exception;
use FiloBlu\Flow\Model\Inboundflow;
use FiloBlu\Flow\Model\InboundflowFactory;
use FiloBlu\Flow\Model\ResourceModel\Inboundflow\CollectionFactory;
use Magento\Backend\App\Action\Context;
use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\Framework\App\Response\Http\FileFactory;
use Magento\Framework\App\ResponseInterface;
use Magento\Framework\Controller\Result\Raw;
use Magento\Framework\Controller\Result\RawFactory;
use Magento\Framework\Controller\ResultInterface;

/**
 * Class Download
 * @package FiloBlu\Flow\Block\Adminhtml\Inboundflow
 */
class Download extends Action
{
    /**
     * @var RawFactory
     */
    protected $resultRawFactory;

    /**
     * @var FileFactory
     */
    protected $fileFactory;

    /**
     * @var InboundflowFactory
     */
    protected $inboundFlowCollectionFactory;

    /**
     * Download constructor.
     * @param RawFactory $resultRawFactory
     * @param FileFactory $fileFactory
     * @param Context $context
     * @param CollectionFactory $inboundFlowCollectionFactory
     */
    public function __construct(
        RawFactory $resultRawFactory,
        FileFactory $fileFactory,
        Context $context,
        CollectionFactory $inboundFlowCollectionFactory
    ) {
        $this->resultRawFactory = $resultRawFactory;
        $this->fileFactory = $fileFactory;
        $this->inboundFlowCollectionFactory = $inboundFlowCollectionFactory;
        parent::__construct($context);
    }

    /**
     * @return ResponseInterface|Raw|ResultInterface
     */
    public function execute()
    {
        try {
            $id = $this->getRequest()->getParam('id', 0);

            /** @var Inboundflow $inboundFlow */
            $inboundFlow = $this->inboundFlowCollectionFactory
                ->create()
                ->addFilter('id', $id)->getFirstItem();

            if ($inboundFlow === null) {
                $this->messageManager->addErrorMessage("Unable to find inbound flow with id {$id}");
                return $this->resultRedirectFactory->create()->setPath('flow/inboundflow/index');
            }

            if ($inboundFlow->getType() === 'file' || $inboundFlow->getType() === 'store_availability') {
                $this->fileFactory->create(
                    $inboundFlow->getName(),
                    [
                        'type' => 'filename',
                        'value' => '/common/bouncer/' . $inboundFlow->getName(),
                    ],
                    DirectoryList::VAR_DIR,
                    'application/octet-stream',
                    ''
                );

                return $this->resultRawFactory->create();
            }
        } catch (Exception $exception) {
            $this->messageManager->addExceptionMessage($exception);
            return $this->resultRedirectFactory->create()->setPath('flow/inboundflow/index');
        }

        $this->messageManager->addErrorMessage("This file can not be downloaded {$inboundFlow->getName()}");
        return $this->resultRedirectFactory->create()->setPath('flow/inboundflow/index');
    }
}
