<?php

namespace FiloBlu\Flow\Console\Command;

use FiloBlu\Flow\Cron\Fetch;
use Magento\Framework\Exception\LocalizedException;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class ParseCommand
 * @package FiloBlu\Flow\Console\Command
 */
class ParseCommand extends BaseCommand
{
    /**
     *
     */
    protected function configure()
    {
        $this->setName('flow:parse')->setDescription('Parse data channels');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int
     * @throws LocalizedException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->ensureAreaCode($output);

        /** @var Fetch cronModel */
        $cronModel = $this->fetchFactory->create();
        $cronModel->parse();
        $output->writeln('<info>Parsed executed !</info>');

        return 0;
    }
}
