<?php
declare(strict_types=1);

namespace FiloBlu\Flow\Console\Command;

use FiloBlu\Flow\Helper\SharedCatalogHelper;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class AssignGroupedToSharedCatalogs
 * @package FiloBlu\Flow\Console\Command
 */
class AssignGroupedToSharedCatalogs extends Command
{

    /**
     * @var SharedCatalogHelper
     */
    private $sharedCatalogHelper;

    public function __construct(
        SharedCatalogHelper $sharedCatalogHelper,
        $name = null
    )
    {
        parent::__construct($name);
        $this->sharedCatalogHelper = $sharedCatalogHelper;
    }

    /**
     *
     */
    protected function configure()
    {
        $this->setName('flow:assigngroupedtosharedcatalogs')
            ->setDescription('add all the grouped to all the shared catalogs of the children');
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @return int|null|void
     * @throws LocalizedException
     * @throws NoSuchEntityException
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->sharedCatalogHelper->assignGroupedToSharedCatalog();
        $output->writeln('<info>Grouped assigned to children\'s Shared Catalogs</info>');

        return 0;
    }
}
