<?php

namespace FiloBlu\Flow\Block\Adminhtml\Inboundflow;

use FiloBlu\Flow\Model\ResourceModel\Inboundflow\CollectionFactory;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Helper\Data;
use Magento\Catalog\Model\Product;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\LocalizedException;

/**
 * Class Grid
 * @package FiloBlu\Flow\Block\Adminhtml\Inboundflow
 */
class Grid extends Extended
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @param Context $context
     * @param Data $backendHelper
     * @param CollectionFactory $collectionFactory
     * @param array $data
     *
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     */
    public function __construct(
        Context           $context,
        Data              $backendHelper,
        CollectionFactory $collectionFactory,
        array             $data = []
    )
    {
        parent::__construct($context, $backendHelper, $data);
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @return string
     */
    public function getGridUrl()
    {
        return $this->getUrl('flow/*/index', ['_current' => true]);
    }

    /**
     * @param Product|DataObject $row
     * @return string
     */
    public function getRowUrl($row)
    {
        return $this->getUrl(
            'flow/*/edit',
            ['store' => $this->getRequest()->getParam('store'), 'id' => $row->getId()]
        );
    }

    /**
     * @return Grid
     */
    protected function _prepareCollection()
    {
        if (!$this->getCollection()) {
            $this->setCollection($this->collectionFactory->create());
        }

        return parent::_prepareCollection();
    }

    /**
     * @return void
     * @throws FileSystemException
     */
    protected function _construct()
    {
        parent::_construct();

        $this->setId('InboundflowGrid');
        $this->setDefaultSort('id');
        $this->setDefaultDir('DESC');
        $this->setSaveParametersInSession(true);
        $this->setUseAjax(false);
    }


    /**
     * @return Extended
     * @throws LocalizedException
     */
    protected function _prepareColumns()
    {
        $this->addColumn(
            'id',
            [
                'header'           => __('ID'),
                'type'             => 'number',
                'index'            => 'id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );
        $this->addColumn(
            'id',
            [
                'header' => __('Id'),
                'type'   => 'number',
                'index'  => 'id',
                'class'  => 'id'
            ]
        );
        $this->addColumn(
            'name',
            [
                'header' => __('Name'),
                'index'  => 'name',
                'class'  => 'name'
            ]
        );
        $this->addColumn(
            'flow',
            [
                'header' => __('Flow'),
                'index'  => 'flow',
                'class'  => 'flow'
            ]
        );
        $this->addColumn(
            'type',
            [
                'header' => __('Type'),
                'index'  => 'type',
                'class'  => 'type'
            ]
        );
        $this->addColumn(
            'channel',
            [
                'header' => __('Channel'),
                'index'  => 'channel',
                'class'  => 'channel'
            ]
        );
        $this->addColumn(
            'priority',
            [
                'header' => __('Priority'),
                'index'  => 'priority',
                'class'  => 'priority'
            ]
        );
        $this->addColumn(
            'status',
            [
                'header' => __('Status'),
                'index'  => 'status',
                'class'  => 'status'
            ]
        );
        $this->addColumn(
            'retry',
            [
                'header' => __('Retry'),
                'index'  => 'retry',
                'class'  => 'retry'
            ]
        );
        $this->addColumn(
            'lines',
            [
                'header' => __('Processed Lines'),
                'index'  => 'retry',
                'class'  => 'retry'
            ]
        );

        $this->addColumn(
            'errors',
            [
                'header' => __('Errors'),
                'index'  => 'errors',
                'class'  => 'errors'
            ]
        );
        $this->addColumn(
            'last_activity',
            [
                'header' => __('Last activity'),
                'index'  => 'last_activity',
                'type'   => 'datetime',
            ]
        );
        $this->addColumn(
            'receiving_time',
            [
                'header' => __('Receiving Time'),
                'index'  => 'receiving_time',
                'type'   => 'datetime',
            ]
        );
        $this->addColumn(
            'action',
            [
                'header'           => __('Action'),
                'type'             => 'action',
                'getter'           => 'getId',
                'actions'          => [
                    [
                        'caption' => __('Download'),
                        'url'     => [
                            'base' => 'flow/*/download',
                        ],
                        'field'   => 'id'
                    ]
                ],
                'filter'           => false,
                'sortable'         => false,
                'index'            => 'increment_id',
                'header_css_class' => 'col-action',
                'column_css_class' => 'col-action'
            ]
        );

        $block = $this->getLayout()->getBlock('grid.bottom.links');
        if ($block) {
            $this->setChild('grid.bottom.links', $block);
        }

        return parent::_prepareColumns();
    }

    /**
     * @return $this
     */
    protected function _prepareMassaction()
    {
        $this->setMassactionIdField('id');
        $this->getMassactionBlock()->setFormFieldName('id');

        $this->getMassactionBlock()->addItem(
            'delete',
            [
                'label'   => __('Delete'),
                'url'     => $this->getUrl('flow/*/massDelete'),
                'confirm' => __('Are you sure?')
            ]
        );
        return $this;
    }
}
