<?php

namespace FiloBlu\Flow\Block\Adminhtml\Channel\Edit\Tab;

use FiloBlu\Flow\Model\Channel;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Data\Form;
use Magento\Framework\Exception\LocalizedException;

/**
 * Class General
 * @package FiloBlu\Flow\Block\Adminhtml\Channel\Edit\Tab
 */
class General extends Generic implements TabInterface
{
    /**
     * Prepare label for tab
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('General');
    }

    /**
     * Prepare title for tab
     *
     * @return string
     */
    public function getTabTitle()
    {
        return __('General');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * @return Generic
     * @throws LocalizedException
     */
    protected function _prepareForm()
    {
        /** @var Channel $model */
        $model = $this->_coreRegistry->registry('flow_channel');

        /** @var Form $form */
        $form = $this->_formFactory->create();

        $form->setHtmlIdPrefix('page_');

        $fieldset = $form->addFieldset('general_fieldset', [
            'legend' => __('General')
        ]);

        if ($model->getId()) {
            $fieldset->addField('id', 'hidden', [
                'name' => 'id'
            ]);
        }

        $fieldset->addField(
            'name',
            'text',
            [
                'name'     => 'name',
                'label'    => __('Name'),
                'title'    => __('name'),
                'required' => true,
            ]
        );
        $fieldset->addField(
            'type',
            'select',
            [
                'name'     => 'type',
                'label'    => __('Type'),
                'title'    => __('type'),
                'options'  => ['in' => 'IN', 'out' => 'OUT'],
                'required' => true,
                'default'  => 'in'
            ]
        );

        $form->setValues($model->getData());
        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }
}
