<?php
/**
 * Copyright © 2015 FiloBlu. All rights reserved.
 */

namespace FiloBlu\Flow\Model;

use Magento\Framework\Data\Collection\AbstractDb;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\Context;
use Magento\Framework\Model\ResourceModel\AbstractResource;
use Magento\Framework\Registry;

/**
 * Class Imagesflow
 * @method string getImageName()
 * @method string getImageSku()
 * @method string getImagePosition()
 * @method string getImagePath()
 * @method string getImageType()
 * @method string getImageHide()
 * @method string getImageStatus()
 * @method string getImageAlt()
 * @method string getImageProcessTime()
 * @method string getMetaProcessed()
 * @method int getMetaFile()
 * @method self setImageName(string $name)
 * @method self setImageSku(string $sku)
 * @method self setImagePosition(string $position)
 * @method self setImagePath(string $path)
 * @method self setImageType(string $type)
 * @method self setImageHide(int $hide)
 * @method self setImageStatus(string $status)
 * @method self setImageAlt(string $alt)
 * @method self setMetaFile(int $metafile)
 * @method self setImageProcessTime(string $time)
 * @method self setMetaProcessed(string $processed)
 * @package FiloBlu\Flow\Model
 */
class Imagesflow extends AbstractModel
{
    /**
     * @var string
     */
    const STATUS_FOUND = 'found';

    /**
     * @var string
     */
    const STATUS_RECEIVED = 'received';

    /**
     * @var string
     */
    const STATUS_PARSED = 'parsed';

    /**
     * @var string
     */
    const STATUS_PROCESSED = 'processed';

    /**
     * @var string
     */
    const STATUS_ERROR = 'error';

    /**
     * @var string
     */
    const PRIORITY_HIGH = 'high';

    /**
     * @var string
     */
    const PRIORITY_LOW = 'low';

    /**
     * @var string
     */
    const PRIORITY_NORMAL = 'normal';

    /**
     * Imagesflow constructor.
     * @param Context $context
     * @param Registry $registry
     * @param AbstractResource|null $resource
     * @param AbstractDb|null $resourceCollection
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        AbstractResource $resource = null,
        AbstractDb $resourceCollection = null,
        array $data = []
    ) {
        parent::__construct($context, $registry, $resource, $resourceCollection, $data);
    }

    /**
     * @return void
     */
    public function _construct()
    {
        $this->_init(ResourceModel\Imagesflow::class);
    }
}
