<?php

namespace FiloBlu\Flow\Model\From;

use Exception;
use FiloBlu\Flow\Helper\Data;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Model\Context;
use Magento\Framework\Registry;
use Magento\Store\Model\StoreManagerInterface;
use Monolog\Logger;
use Magento\Framework\App\ResourceConnection;
use Magento\Newsletter\Model\Subscriber as MagentoSubscriber;

/**
 * Class Price
 * @package FiloBlu\Flow\Model\From
 */
class Subscriber extends AbstractFrom
{
    /**
     * @var mixed
     */
    protected $_configurableAction;
    /**
     * @var StoreManagerInterface
     */
    protected $_storeManager;
    /**
     * @var Data
     */
    protected $_helper_flow;
    /**
     * @var ResourceConnection
     */
    public $subscriber_resource;
    /**
     * @var
     */
    public $subscriber_connection;

    protected $allowed_statuses;

    /**
     * Price constructor.
     * @param Context $context
     * @param Registry $registry
     * @param Data $helper_flow
     * @param StoreManagerInterface $storeManager
     * @param ResourceConnection $subscriber_resource
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        Data $helper_flow,
        StoreManagerInterface $storeManager,
        ResourceConnection $subscriber_resource,
        array $data = []
    ) {
        $this->_helper_flow = $helper_flow;
        $this->_storeManager = $storeManager;
        $this->subscriber_resource = $subscriber_resource;
        parent::__construct($context, $registry, null, null, $data);
    }

    /**
     * @return void
     * @noinspection MagicMethodsValidityInspection
     */
    public function _construct()
    {
        $this->_init(\FiloBlu\Flow\Model\ResourceModel\From\Subscriber::class);
        $this->allowed_statuses = [
            MagentoSubscriber::STATUS_SUBSCRIBED,
            MagentoSubscriber::STATUS_NOT_ACTIVE,
            MagentoSubscriber::STATUS_UNSUBSCRIBED,
            MagentoSubscriber::STATUS_UNCONFIRMED
        ];
    }

    /**
     * @return $this|bool|mixed
     * @throws Exception
     */
    public function process()
    {
        $email = $this->getEmail();
        $store_id = $this->getStoreId();
        $status = $this->getStatus();

        if(!$email){
            $message = 'Email is empty!';
            return $this->error(false, $message);
        }

        if(!$store_id){
            //When there is no store id then execute the action on all
            //$message = "Store ID is empty!";
            //return $this->error(false, $message);
        }
        $allStoreIds = $this->_helper_flow->getAllStoreIds();
        if ($store_id && !in_array($store_id,$allStoreIds)){
            $message = "Store ID {$store_id} not found!";
            return $this->error(false, $message);
        }

        if (!in_array($status,$this->allowed_statuses)){
            $message = "Status {$status} not valid!";
            return $this->error(false, $message);
        }

        // Direct database query to bypass all MAPP (or other modules) observers and plugins
        $sql = "UPDATE newsletter_subscriber
                SET subscriber_status = {$status}
                WHERE subscriber_email = '{$email}' AND subscriber_status <> {$status} ";

        if ($store_id){
            $sql .= " AND store_id = {$store_id} ";
        }

        $this->getConnection()->query($sql);

        return $this;
    }

    /**
     * @param $file
     * @return bool|mixed
     */
    public function sendErrorNotifications($file)
    {
        return true;
    }

    public function getConnection()
    {
        if (!$this->subscriber_connection) {
            $this->subscriber_connection = $this->subscriber_resource->getConnection('core_write');
        }
        return $this->subscriber_connection;
    }
}
