<?php

namespace FiloBlu\Flow\Model\Filters;

use FiloBlu\Flow\Helper\DataFactory;

/**
 * Class SetDefaultLocale
 * @package FiloBlu\Flow\Model\Filters
 */
class SetDefaultLocale extends AbstractFilter
{

    /**
     * @var DataFactory
     */
    protected $dataFactory;

    /**
     * SetDefaultLocale constructor.
     * @param DataFactory $dataFactory
     */
    public function __construct(DataFactory $dataFactory)
    {
        $this->dataFactory = $dataFactory;
    }

    /**
     * @param $value
     * @param $args
     * @return string
     */
    public function filter($value, $args)
    {

        $v = trim($value ?? '');

        if ($v === '') {
            return '';
        }

        $default_locale = $args['default'];
        $sku_field = (int)$args['sku'];
        $sku = $this->_row[$sku_field];

        $helperProduct = $this->dataFactory->get();
        $stores = implode(';', $helperProduct->getStoresCodeByLocale($default_locale));

        return $value . '|||' . $stores . '|||' . $sku;
    }

}

