<?php

namespace FiloBlu\Flow\Model\Filters;

/**
 * Class Concat
 * @package FiloBlu\Flow\Model\Filters
 */
class Concat extends AbstractFilter
{

    /**
     * @param $value
     * @param $args
     * @return mixed|string
     */
    public function filter($value, $args)
    {
        $rowToConcat = $args['rows'];
        $separator = $args['separator'];
        $rowMapped = [];

        if (!is_array($rowToConcat) || empty($rowToConcat)) {
            return $value;
        }

        $row = $this->getRow();

        foreach ($rowToConcat as $currentRow) {
            if (isset($row[$currentRow]) && $row[$currentRow] !== '') {
                $rowMapped[] = $row[$currentRow];
            }
        }

        if (!count($rowMapped)) {
            return $value;
        }

        return implode($separator, $rowMapped);
    }

}

