<?php

namespace FiloBlu\Flow\Block\Adminhtml\Channel;

use FiloBlu\Flow\Model\ResourceModel\Channel\CollectionFactory;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Helper\Data;
use Magento\Catalog\Model\Product;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\LocalizedException;

/**
 * Class Grid
 * @package FiloBlu\Flow\Block\Adminhtml\Channel
 */
class Grid extends Extended
{
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;

    /**
     * @param Context $context
     * @param Data $backendHelper
     * @param CollectionFactory $collectionFactory
     * @param array $data
     *
     * @SuppressWarnings(PHPMD.ExcessiveParameterList)
     */
    public function __construct(
        Context           $context,
        Data              $backendHelper,
        CollectionFactory $collectionFactory,
        array             $data = []
    )
    {
        parent::__construct($context, $backendHelper, $data);
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @return string
     */
    public function getGridUrl()
    {
        return $this->getUrl('flow/*/index', ['_current' => true]);
    }

    /**
     * @param Product|DataObject $row
     * @return string
     */
    public function getRowUrl($row)
    {
        return $this->getUrl(
            'flow/*/edit',
            ['store' => $this->getRequest()->getParam('store'), 'id' => $row->getId()]
        );
    }

    /**
     * @return Grid
     */
    protected function _prepareCollection()
    {
        if (!$this->getCollection()) {
            $this->setCollection($this->collectionFactory->create());
        }

        return parent::_prepareCollection();
    }

    /**
     * @return void
     * @throws FileSystemException
     */
    protected function _construct()
    {
        parent::_construct();

        $this->setId('ChannelGrid');
        $this->setDefaultSort('id');
        $this->setDefaultDir('DESC');
        $this->setSaveParametersInSession(true);
        $this->setUseAjax(false);
    }

    /**
     * @return Extended
     * @throws LocalizedException
     */
    protected function _prepareColumns()
    {
        $this->addColumn(
            'id',
            [
                'header'           => __('ID'),
                'type'             => 'number',
                'index'            => 'id',
                'header_css_class' => 'col-id',
                'column_css_class' => 'col-id'
            ]
        );

        $this->addColumn(
            'id',
            [
                'header' => __('id'),
                'index'  => 'id',
                'class'  => 'id'
            ]
        );

        $this->addColumn(
            'name',
            [
                'header' => __('name'),
                'index'  => 'name',
                'class'  => 'name'
            ]
        );

        $this->addColumn(
            'type',
            [
                'header' => __('type'),
                'index'  => 'type',
                'class'  => 'type'
            ]
        );

        $block = $this->getLayout()->getBlock('grid.bottom.links');

        if ($block) {
            $this->setChild('grid.bottom.links', $block);
        }

        return parent::_prepareColumns();
    }

    /**
     * @return $this
     */
    protected function _prepareMassaction()
    {
        $this->setMassactionIdField('id');
        $this->getMassactionBlock()->setFormFieldName('id');

        $this->getMassactionBlock()->addItem(
            'delete',
            [
                'label'   => __('Delete'),
                'url'     => $this->getUrl('flow/*/massDelete'),
                'confirm' => __('Are you sure?')
            ]
        );
        return $this;
    }
}
