<?php

namespace FiloBlu\Flow\Block\Adminhtml\Channel\Edit\Tab;

use FiloBlu\Flow\Helper\Data;
use FiloBlu\Flow\Model\Channel;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Form\Element\Dependence;
use Magento\Backend\Block\Widget\Form\Generic;
use Magento\Backend\Block\Widget\Tab\TabInterface;
use Magento\Framework\Data\Form;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Registry;

/**
 * Class Connector
 * @package FiloBlu\Flow\Block\Adminhtml\Channel\Edit\Tab
 */
class Connector extends Generic implements TabInterface
{

    /**
     * @var Data
     */
    protected $helper;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param Data $helper
     * @param array $data
     */

    public function __construct(
        Context $context,
        Registry $registry,
        FormFactory $formFactory,
        Data $helper,
        array $data = []
    )
    {
        $this->helper = $helper;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    /**
     * Prepare label for tab
     *
     * @return string
     */
    public function getTabLabel()
    {
        return __('Connector');
    }

    /**
     * Prepare title for tab
     *
     * @return string
     */
    public function getTabTitle()
    {
        return __('connector');
    }

    /**
     * {@inheritdoc}
     */
    public function canShowTab()
    {
        return true;
    }

    /**
     * {@inheritdoc}
     */
    public function isHidden()
    {
        return false;
    }

    /**
     * Prepare form
     *
     * @return $this
     * @throws LocalizedException
     */
    protected function _prepareForm()
    {
        /** @var Channel $model */
        $model = $this->_coreRegistry->registry('flow_channel');

        /** @var Form $form */
        $form = $this->_formFactory->create();

        $form->setHtmlIdPrefix('page_');

        $fieldset = $form->addFieldset('connector_fieldset', [
            'legend' => __('Connector')
        ]);

        $fieldset->addField('type', 'select', [
            'label' => __('Type'),
            'name'  => 'connector[type]',
            'values'  => [
                'ftp' => 'Ftp',
                'SFtpConnector' => 'SFtp'
            ],
            'default' => 'ftp'
        ]);

        $fieldset->addField('host', 'text', [
            'label' => __('Host'),
            'name'  => 'connector[host]',
        ]);

        $fieldset->addField('username', 'text', [
            'label' => __('Username'),
            'name'  => 'connector[username]',
        ]);

        $auth_type = $fieldset->addField('auth_type', 'select', [
            'label' => __('Auth Type'),
            'name'  => 'connector[auth_type]',
            'values'  => [
                'password' => 'Password',
                'key' => 'Key'
            ],
            'default' => 'password'
        ]);

        $auth_password = $fieldset->addField('password', 'text', [
            'label' => __('Password'),
            'name'  => 'connector[password]',
        ]);

        $auth_key = $fieldset->addField('private_key','textarea', [
                'label'    => __('Private Key'),
                'name'     => 'connector[private_key]',
                'rows'  => 25
        ]);

        $fieldset->addField('passive', 'select',
            [
                'label'   => __('Passive Mode'),
                'name'    => 'connector[passive]',
                'values'  => [
                    '0' => 'No',
                    '1' => 'Yes'
                ],
                'default' => '1'
            ]
        );

        $fieldset->addField('ftp_dir', 'text', [
            'label'   => __('Ftp Dir'),
            'name'    => 'connector[ftp_dir]',
            'default' => '/IN_LOCAL'
        ]);

        $fieldset->addField('local_dir', 'text', [
            'label'   => __('Local Dir'),
            'name'    => 'connector[local_dir]',
            'default' => 'common/bouncer'
        ]);

        $destinationDir = $fieldset->addField('destination_dir', 'text', [
            'label' => __('Destination Dir'),
            'name'  => 'connector[destination_dir]',
            'note'  => 'This will write only in pub -> media folder. Please do not write \'pub/media\' in the path and do not add slashes ( / ) at the beginning and at the end of path',
        ]);

        $fieldset->addField('regex', 'text', [
            'label' => __('File Mask'),
            'name'  => 'connector[regex]',
        ]);

        $this->setChild(
            'form_after',
            $this->getLayout()->createBlock(Dependence::class)
                ->addFieldMap('page_flow', 'config[flow]')
                ->addFieldMap($destinationDir->getHtmlId(), $destinationDir->getName())
                ->addFieldMap($auth_type->getHtmlId(), $auth_type->getName())
                ->addFieldMap($auth_password->getHtmlId(), $auth_password->getName())
                ->addFieldMap($auth_key->getHtmlId(), $auth_key->getName())
                ->addFieldDependence($destinationDir->getName(), 'config[flow]', 'Document')
                ->addFieldDependence($auth_password->getName(), $auth_type->getName(), 'password')
                ->addFieldDependence($auth_key->getName(), $auth_type->getName(), 'key')
        );

        $form->setValues($model->getData('connector'));
        $this->setForm($form);

        return parent::_prepareForm();
    }

    /**
     * Check permission for passed action
     *
     * @param string $resourceId
     * @return bool
     */
    protected function _isAllowedAction($resourceId)
    {
        return $this->_authorization->isAllowed($resourceId);
    }
}
