<?php

namespace FiloBlu\Rma\Ui\Component\Listing\Columns\Order;

use FiloBlu\Rma\Helper\EasyReturnHelper;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;

/**
 *
 */
class RmaType extends Column
{
    /**
     * @var EasyReturnHelper
     */
    protected $easyReturnHelper;

    /**
     * @param \Magento\Framework\View\Element\UiComponent\ContextInterface $context
     * @param \Magento\Framework\View\Element\UiComponentFactory $uiComponentFactory
     * @param \FiloBlu\Rma\Helper\EasyReturnHelper $easyReturnHelper
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context ,
        UiComponentFactory $uiComponentFactory ,
        EasyReturnHelper $easyReturnHelper,
        array $components = [] ,
        array $data = []
    )
    {
        $this->easyReturnHelper = $easyReturnHelper;
        parent::__construct($context , $uiComponentFactory , $components , $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {

                $label = __('Default');

                if ($this->easyReturnHelper->isEasyReturn($item['entity_id'])) {
                    $label = __('Easy Return');
                }

                $item[$this->getData('name')] = $label;
            }
        }

        return $dataSource;
    }
}
