<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 28/02/20
 * Time: 15.10
 */

namespace FiloBlu\Rma\Tax\Block\Sales\Order;

use Exception;
use FiloBlu\Rma\Model\Payment\ChangeSizePay;
use Magento\Framework\View\Element\Template\Context;
use Magento\Tax\Model\Config;

/**
 *
 */
class Tax extends \Magento\Tax\Block\Sales\Order\Tax
{
    /**
     * Tax constructor.
     * @param Context $context
     * @param Config $taxConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        Config $taxConfig,
        array $data = []
    )
    {
        parent::__construct($context, $taxConfig, $data);
    }


    /**
     * @return mixed
     */
    public function getTaxAmount()
    {
        try {
            $order = $this->getOrder();
            if ($order->getPayment()->getMethod() == ChangeSizePay::PAYMENT_CODE) {

                $tax = 0;
                foreach ($order->getAllVisibleItems() as $item) {
                    $tax += (float)$item->getTaxAmount();
                }
                return $tax;
            }

            return $this->getSource()->getTaxAmount();
        } catch (Exception $exception) {
            $this->_logger->critical($exception->getMessage(), ['exception' => $exception]);
            return $this->getSource()->getTaxAmount();
        }
    }
}
