<?php

namespace FiloBlu\Rma\Setup;

use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class Recurring implements InstallSchemaInterface
{
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $this->installFiloBluChangeSizeItemsTable($setup);
        $setup->endSetup();
    }

    /**
     * @param SchemaSetupInterface $setup
     * @return false|void
     * @throws Zend_Db_Exception
     */
    public function installFiloBluChangeSizeItemsTable(SchemaSetupInterface $setup)
    {
        $tableName = $setup->getTable('filoblu_change_size_items');

        if ($setup->getConnection()->isTableExists($tableName)) {
            return false;
        }

        $table = $setup->getConnection()
            ->newTable($tableName)
            ->addColumn(
                'item_id',
                Table::TYPE_INTEGER,
                null,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'Item ID'
            )
            ->addColumn(
                'parent_order_id',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                'Parent Order ID'
            )
            ->addColumn(
                'parent_order_increment_id',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'Parent Order Increment ID'
            )
            ->addColumn(
                'rma_id',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                'RMA ID'
            )
            ->addColumn(
                'rma_increment_id',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'RMA Increment ID'
            )
            ->addColumn(
                'parent_order_item',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                'Parent Order Item'
            )
            ->addColumn(
                'parent_product_sku',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'Parent Product SKU'
            )
            ->addColumn(
                'new_product_sku',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'New Product SKU'
            )
            ->addColumn(
                'is_easy_return',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                'Is Easy Return'
            )
            ->addColumn(
                'rma_item_id',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                'Rma Item Id'
            )
            ->addColumn(
                'change_size_order_id',
                Table::TYPE_INTEGER,
                null,
                ['nullable' => false],
                'Change Size Order ID'
            )
            ->addColumn(
                'change_size_order_increment_id',
                Table::TYPE_TEXT,
                255,
                ['nullable' => false],
                'Change Size Order Increment ID'
            )
            ->setOption('charset', 'utf8mb3')
            ->setOption('engine', 'InnoDB');

        $setup->getConnection()->createTable($table);

    }
}
