<?php

namespace FiloBlu\Rma\Plugin\Sales\Model\Order;

use FiloBlu\Rma\Helper\BundlesHelper;

class ItemIsDummy
{
    /**
     * @var BundlesHelper
     */
    private $bundlesHelper;

    /**
     * @param BundlesHelper $bundlesHelper
     */
    public function __construct(
        BundlesHelper $bundlesHelper
    )
    {
        $this->bundlesHelper = $bundlesHelper;
    }

    public function afterIsDummy($subject, $result, $shipment = false)
    {
        if (!$this->bundlesHelper->isAllowShippedSeparatelyItemsMarkedAsShipped()) {
            return $result;
        }

        if ($subject->getHasChildren() && $subject->isShipSeparately()) {
            return false;
        }

        return $result;
    }
}
