<?php

namespace FiloBlu\Rma\Plugin\Rma\Block\Returns;

use FiloBlu\Rma\Helper\ReturnableProductHelper;

/**
 *
 */
class Create
{
    /**
     * @var ReturnableProductHelper
     */
    private $returnableProductHelper;

    /**
     * @param \FiloBlu\Rma\Helper\ReturnableProductHelper $returnableProductHelper
     */
    public function __construct(
        ReturnableProductHelper $returnableProductHelper
    )
    {
        $this->returnableProductHelper = $returnableProductHelper;
    }

    /**
     * @param $subject
     * @param $result
     * @return mixed
     */
    public function afterGetItems($subject, $result)
    {
        foreach ($result as $key => $item) {
            $product = $item->getProduct();

            if (!$this->returnableProductHelper->isProductReturnable($product, $item->getSku())) {
                unset($result[$key]);
            }
        }

        return $result;
    }
}