<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 04/03/20
 * Time: 17.28
 */

namespace FiloBlu\Rma\Plugin\Model\Order\Email;

use FiloBlu\Rma\Api\RmaExtensionAttributesRepositoryInterface;
use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use FiloBlu\Rma\Model\Order\Email\Sender\ChangeSizeOrderSender;
use Magento\Framework\App\Config\ScopeConfigInterface;
use Magento\Sales\Model\Order;
use Magento\Sales\Model\ResourceModel\Order as OrderResource;
use Psr\Log\LoggerInterface;
use Throwable;

/**
 *
 */
class OrderSender
{
    /**
     * @var RmaExtensionAttributesRepositoryInterface
     */
    protected $rmaExtensionAttributesRepository;

    /**
     * @var ChangeSizeOrderSender
     */
    protected $changeSizeOrderSender;

    /**
     * @var ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var OrderResource
     */
    private $orderResource;


    /**
     * OrderSender constructor.
     * @param RmaExtensionAttributesRepositoryInterface $rmaExtensionAttributesRepository
     * @param ChangeSizeOrderSender $changeSizeOrderSender
     * @param ScopeConfigInterface $scopeConfig
     * @param LoggerInterface $logger
     * @param OrderResource $orderResource
     */
    public function __construct(
        RmaExtensionAttributesRepositoryInterface $rmaExtensionAttributesRepository,
        ChangeSizeOrderSender                     $changeSizeOrderSender,
        ScopeConfigInterface                      $scopeConfig,
        LoggerInterface                           $logger,
        OrderResource                             $orderResource)
    {
        $this->rmaExtensionAttributesRepository = $rmaExtensionAttributesRepository;
        $this->changeSizeOrderSender = $changeSizeOrderSender;
        $this->scopeConfig = $scopeConfig;
        $this->logger = $logger;
        $this->orderResource = $orderResource;
    }


    /**
     * @param Order\Email\Sender\OrderSender $subject
     * @param callable $proceed
     * @param Order $order
     * @param bool $forceSyncMode
     * @return bool
     */
    public function aroundSend(Order\Email\Sender\OrderSender $subject, callable $proceed, Order $order, $forceSyncMode = false)
    {

        try {
            if ($order->getPayment()->getMethod() == 'changesizepay' || ($order->getState() == Order::STATE_NEW &&
                $order->getStatus() == ChangeSizeAttributeHelper::ORDER_STATUS_CHANGESIZE_CODE)
            ) {
                if (!$this->scopeConfig->getValue('sales_email/general/async_sending') || $forceSyncMode) {
                    if ($this->changeSizeOrderSender->send($order, $forceSyncMode)) {
                        return true;
                    }
                } else {
                    $order->setEmailSent(null);
                    $this->orderResource->saveAttribute($order, 'email_sent');
                }

            } else {
                return $proceed($order, $forceSyncMode);
            }

            $this->orderResource->saveAttribute($order, 'send_email');
            return false;

        } catch (Throwable $t) {
            $this->logger->critical($t->getMessage());
            return false;
        }
    }

}
