<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 04/11/19
 * Time: 0.42
 */

namespace FiloBlu\Rma\Plugin\Model;
use FiloBlu\Rma\Plugin\Block\Form\Renderer\Select;
use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use Magento\Framework\App\RequestInterface;
use Magento\Rma\Api\RmaRepositoryInterface;
use Magento\Rma\Helper\Eav;
use Magento\Store\Model\StoreManagerInterface;
use Psr\Log\LoggerInterface;

/**
 *
 */
class HideChangeSizeResolution
{

    /**
     * @var ChangeSizeAttributeHelper
     */
    protected $changeSizeAttributeHelper;

    /**
     * @var Select
     */
    protected $select;

    /**
     * @var RequestInterface
     */
    protected $requestInterface;

    /**
     * @var RmaRepositoryInterface
     */
    protected $rmaRepositoryInterface;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * HideChangeSizeResolution constructor.
     * @param Select $select
     * @param ChangeSizeAttributeHelper $changeSizeAttributeHelper
     * @param RequestInterface $request
     * @param RmaRepositoryInterface $rmaRepository
     * @param StoreManagerInterface $storeManager
     * @param LoggerInterface $logger
     */
    public function __construct(
        Select $select,
        ChangeSizeAttributeHelper $changeSizeAttributeHelper,
        RequestInterface $request,
        RmaRepositoryInterface $rmaRepository,
        StoreManagerInterface $storeManager,
        LoggerInterface $logger){

        $this->select = $select;
        $this->changeSizeAttributeHelper = $changeSizeAttributeHelper;
        $this->requestInterface = $request;
        $this->rmaRepositoryInterface = $rmaRepository;
        $this->storeManager = $storeManager;
        $this->logger = $logger;
    }

    /**
     * @param Eav $subject
     * @param $result
     * @return array
     */
    public function afterGetAttributeOptionValues(Eav $subject, $result){

        try{
            $allowed = [];
            $pathInfo = $this->requestInterface->getPathInfo();
            $rmaId = $this->requestInterface->getParam('id');
            $rma = $this->rmaRepositoryInterface->get($rmaId);
            $storeId = $rma->getStoreId();
            if(stripos($pathInfo, 'admin/rma/edit') !== false){
                $websiteId = $this->storeManager->getStore($storeId)->getWebsiteId();
            }else{
                $websiteId = null;
            }
            if(!$this->select->changeSizeIsEnabled($websiteId)){
                foreach ($result as $key => $options){
                    if(!in_array($options,[$this->changeSizeAttributeHelper->getChangeSizeLabelByStoreId()]) && !in_array($options,[$this->changeSizeAttributeHelper->getChangeSizeLabelByStoreId($storeId)])){
                        $allowed [$key]= $options;
                    }
                }
                $result = $allowed;
            }
            return $result;
        }catch (\Exception $e){
            $this->logger->critical($e->getMessage());
            return $result;
        }catch (\Throwable $t){
            $this->logger->critical($t->getMessage());
            return $result;
        }

    }

}
