<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 20/04/20
 * Time: 10.54
 */

namespace FiloBlu\Rma\Plugin\Helper;

use Exception;
use FiloBlu\Rma\Handlers\CanCreateRmaHandler;
use FiloBlu\Rma\Handlers\CustomCarrierHandler;
use FiloBlu\Rma\Handlers\DisablePersonalizedOrderRmaHanlder;
use FiloBlu\Rma\Helper\RmaHelper;
use Magento\Rma\Helper\Data;
use Psr\Log\LoggerInterface;
use Throwable;


/**
 *
 */
class RmaHelperDataProcessor
{
    /**
     * @var DisablePersonalizedOrderRmaHanlder
     */
    private $disablePersonalizedOrderRmaHanlder;
    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var CanCreateRmaHandler
     */
    private $canCreateRmaHandler;
    /**
     * @var CustomCarrierHandler
     */
    private $carrierHandler;
    /**
     * @var RmaHelper
     */
    private $rmaHelper;

    /**
     * RmaHelperDataProcessor constructor.
     * @param DisablePersonalizedOrderRmaHanlder $disablePersonalizedOrderRmaHanlder
     * @param LoggerInterface $logger
     * @param CanCreateRmaHandler $canCreateRmaHandler
     * @param CustomCarrierHandler $carrierHandler
     * @param RmaHelper $rmaHelper
     */
    public function __construct(
        DisablePersonalizedOrderRmaHanlder $disablePersonalizedOrderRmaHanlder,
        LoggerInterface $logger,
        CanCreateRmaHandler $canCreateRmaHandler,
        CustomCarrierHandler $carrierHandler,
        RmaHelper $rmaHelper
    ) {
        $this->disablePersonalizedOrderRmaHanlder = $disablePersonalizedOrderRmaHanlder;
        $this->logger = $logger;
        $this->canCreateRmaHandler = $canCreateRmaHandler;
        $this->carrierHandler = $carrierHandler;
        $this->rmaHelper = $rmaHelper;
    }


    /**
     * @param Data $subject
     * @param callable $proceed
     * @param $order
     * @param false $forceCreate
     * @return false|mixed|null
     */
    public function aroundCanCreateRma(Data $subject, callable $proceed, $order, $forceCreate = false)
    {
        try {
            $lastResult = $this->canCreateRmaHandler->canCreateRma($order, $forceCreate);

            if (!$lastResult) {
                return false;
            }

            $magentoResult = $proceed($order, $forceCreate);

            if (!$magentoResult) {
                return $magentoResult;
            }

            return $this->disablePersonalizedOrderRmaHanlder->canCreateRmaForPersonalizedOrder(true, $order);
        } catch (Exception $e) {
            $this->logger->critical($e->getMessage());
        } catch (Throwable $t) {
            $this->logger->critical($t->getMessage());
        }
        return false;
    }

    /**
     * @param Data $subject
     * @param $result
     * @return array
     */
    public function afterGetShippingCarriers(Data $subject, $result)
    {
        try {
            return $this->carrierHandler->getShippingCarriers($result);
        } catch (Exception $e) {
            $this->logger->critical($e->getMessage());
        } catch (Throwable $t) {
            $this->logger->critical($t->getMessage());
        }

        return $result;
    }

}
