<?php

namespace FiloBlu\Rma\Model;

use FiloBlu\Rma\Api\Data\RmaOptionInterface;
use Magento\Customer\Model\Data\Option;

/**
 *
 */
class RmaOption extends Option implements RmaOptionInterface
{
    /**
     * @return bool
     */
    public function getIbanRequiredForRma(): bool
    {
        return $this->_get(self::IBAN_REQUIRED_FOR_RMA);
    }

    /**
     * @param $required
     * @return \FiloBlu\Rma\Model\RmaOption
     */
    public function setIbanRequiredForRma($required)
    {
        return $this->setData(self::IBAN_REQUIRED_FOR_RMA, $required);
    }
}
