<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 24/02/20
 * Time: 8.22
 */

namespace FiloBlu\Rma\Model;

use Exception;
use FiloBlu\Rma\Api\EasyReturnRepositoryInterface;
use FiloBlu\Rma\Model\ResourceModel\EasyReturn;
use FiloBlu\Rma\Model\ResourceModel\EasyReturn\CollectionFactory;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Api\SearchResultsInterfaceFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Psr\Log\LoggerInterface;
use Throwable;

/**
 *
 */
class EasyReturnRepository implements EasyReturnRepositoryInterface
{
    /**
     * @var EasyReturnFactory
     */
    private $easyReturnFactory;
    /**
     * @var EasyReturn
     */
    private $resourceModel;
    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;
    /**
     * @var SearchResultsInterfaceFactory
     */
    private $searchResultsInterfaceFactory;


    /**
     * EasyReturnRepository constructor.
     * @param EasyReturnFactory $easyReturnFactory
     * @param EasyReturn $resourceModel
     * @param LoggerInterface $logger
     * @param CollectionFactory $collectionFactory
     * @param SearchResultsInterfaceFactory $searchResultsInterfaceFactory
     */
    public function __construct(
        EasyReturnFactory $easyReturnFactory,
        EasyReturn $resourceModel,
        LoggerInterface $logger,
        CollectionFactory $collectionFactory,
        SearchResultsInterfaceFactory $searchResultsInterfaceFactory
    ) {
        $this->easyReturnFactory = $easyReturnFactory;
        $this->resourceModel = $resourceModel;
        $this->logger = $logger;
        $this->collectionFactory = $collectionFactory;
        $this->searchResultsInterfaceFactory = $searchResultsInterfaceFactory;
    }


    /**
     * @param \FiloBlu\Rma\Model\EasyReturn $easyReturn
     */
    public function save(\FiloBlu\Rma\Model\EasyReturn $easyReturn)
    {
        try {
            $this->resourceModel->save($easyReturn);
        } catch (Exception $e) {
            $this->logger->critical($e->getMessage(), ['exception' => $e]);
        } catch (Throwable $t) {
            $this->logger->critical($t->getMessage(), ['exception' => $t]);
        }
    }

    /**
     * @param int $rmaEntityId
     * @return \FiloBlu\Rma\Model\EasyReturn
     */
    public function getByRmaId(int $rmaEntityId)
    {
        $easyReturnCollection = $this->collectionFactory->create()->addFieldToFilter('rma_entity_id', $rmaEntityId);
        $dataModel = $easyReturnCollection->getFirstItem();
        if (count($easyReturnCollection->getItems()) > 1) {
            $this->logger->critical("Multiple values found in easyReturn Collection with rma_entity_id = $rmaEntityId");
        }
        return $this->easyReturnFactory->create()->setData($dataModel->getData());
    }

    /**
     * @param int $easyReturnEntityId
     * @return void
     * @throws Exception
     */
    public function deleteById(int $easyReturnEntityId)
    {
        $easyReturnData = $this->collectionFactory->create()->getItemById($easyReturnEntityId);
        if (!$easyReturnData) {
            throw new NoSuchEntityException(__('Requested product doesn\'t exist'));
        }
        $easyReturn = $this->easyReturnFactory->create()->setData($easyReturnData);
        $this->delete($easyReturn);
    }

    /**
     * @param \FiloBlu\Rma\Model\EasyReturn $easyReturn
     * @return void
     * @throws Exception
     */
    public function delete(\FiloBlu\Rma\Model\EasyReturn $easyReturn)
    {
        $this->resourceModel->delete($easyReturn);
    }

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria)
    {
        $collection = $this->collectionFactory->create()
            ->addFieldToSelect('*');

        $searchResult = $this->searchResultsInterfaceFactory->create();
        $searchResult->setSearchCriteria($searchCriteria);
        $searchResult->setItems($collection->getItems());
        $searchResult->setTotalCount($collection->getSize());
        return $searchResult;
    }

}
