<?php

namespace FiloBlu\Rma\Model\Configuration;

use FiloBlu\Core\Framework\Model\Mapper;
use FiloBlu\Refilo\Model\Config\AbstractConfigProvider;
use FiloBlu\Rma\Api\Data\EasyReturnConfigInterface;
use Magento\Framework\DataObject;
use Magento\Store\Api\Data\StoreInterface;

if (class_exists(AbstractConfigProvider::class)) {
    /**
     *
     */
    class ExtrmaConfigProvider extends AbstractConfigProvider
    {

        /**
         * @param DataObject $configurations
         * @param StoreInterface|null $store
         * @return array
         */
        protected function prepareData(DataObject $configurations, StoreInterface $store = null): array
        {
            return [
                'enabled'                                     => (bool)$configurations->getDataByPath(EasyReturnConfigInterface::EASY_RETURN_ENABlE_XML_PATH),
                'general_description_cms_block_identifier'    => $configurations->getDataByPath(EasyReturnConfigInterface::GENERAL_DESCRIPTION_CMS_BLOCK_IDENTIFIER),
                'easy_rma_description_cms_block_identifier'   => $configurations->getDataByPath(EasyReturnConfigInterface::EASY_RMA_DESCRIPTION_CMS_BLOCK_IDENTIFIER),
                'easy_rma_description2_cms_block_identifier'  => $configurations->getDataByPath(EasyReturnConfigInterface::EASY_RMA_DESCRIPTION2_CMS_BLOCK_IDENTIFIER),
                'normal_rma_description_cms_block_identifier' => $configurations->getDataByPath(EasyReturnConfigInterface::NORMAL_RMA_DESCRIPTION_CMS_BLOCK_IDENTIFIER),
            ];
        }

        /**
         * @param Mapper $mapper
         * @return Mapper
         */
        protected function setMappings(Mapper $mapper)
        {
            return $mapper
                ->withDestinationRoot('storefrontConfig/sales/rma/easy_return')
                ->add('enabled', 'enabled')
                ->add('general_description_cms_block_identifier', 'general_description_cms_block_identifier')
                ->add('easy_rma_description_cms_block_identifier', 'easy_rma_description_cms_block_identifier')
                ->add('easy_rma_description2_cms_block_identifier', 'easy_rma_description2_cms_block_identifier')
                ->add('normal_rma_description_cms_block_identifier', 'normal_rma_description_cms_block_identifier')
                ->resetDestinationRoot();
        }
    }

} else {
    /**
     *
     */
    class ExtrmaConfigProvider
    {

    }
}
