<?php

namespace FiloBlu\Rma\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;
use Magento\Rma\Model\Rma\Source\Status;

class RmaStatuses implements ArrayInterface
{

    /**
     * @var Status
     */
    protected $rmaStatus;

    /**
     * @param Status $rmaStatus
     */
    public function __construct(
        Status $rmaStatus
    )
    {
        $this->rmaStatus = $rmaStatus;
    }

    /**
     * @return array
     */
    public function toOptionArray()
    {
        $options = [];
        $rmaStatuses = $this->rmaStatus->getAllOptions();
        foreach ($rmaStatuses as $status) {
            $options[] = [
                'value' => $status['value'],
                'label' => $status['label'],
            ];
        }
        return $options;
    }
}
