<?php

namespace FiloBlu\Rma\Model\Config\Source;

use Magento\Framework\Option\ArrayInterface;
use Magento\Rma\Model\Item\Status;


class RmaItemStatuses implements ArrayInterface
{
    protected $itemStatus;

    public function __construct(
        Status $itemStatus
    ) {
        $this->itemStatus = $itemStatus;
    }

    public function toOptionArray()
    {
        return [
            [
                'value' => \Magento\Rma\Model\Item\Attribute\Source\Status::STATE_PENDING,
                'label' => __('Pending')
            ],
            [
                'value' => \Magento\Rma\Model\Item\Attribute\Source\Status::STATE_AUTHORIZED,
                'label' => __('Authorized')
            ],
            [
                'value' => \Magento\Rma\Model\Item\Attribute\Source\Status::STATE_RECEIVED,
                'label' => __('Received')
            ],
            [
                'value' => \Magento\Rma\Model\Item\Attribute\Source\Status::STATE_APPROVED,
                'label' => __('Approved')
            ],
            [
                'value' => \Magento\Rma\Model\Item\Attribute\Source\Status::STATE_REJECTED,
                'label' => __('Rejected')
            ],
            [
                'value' => \Magento\Rma\Model\Item\Attribute\Source\Status::STATE_DENIED,
                'label' => __('Denied')
            ],
        ];
    }
}
