<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 10/06/19
 * Time: 11.15
 */

namespace FiloBlu\Rma\Model\Config\Source;

use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use Magento\Framework\Option\ArrayInterface;

/**
 *
 */
class AttributesMapper implements ArrayInterface
{
    /**
     * @var ChangeSizeAttributeHelper
     */
    protected $changeSizeAttributeHelper;

    /**
     * AttributesMapper constructor.
     * @param ChangeSizeAttributeHelper $changeSizeAttributeHelper
     */
    public function __construct(ChangeSizeAttributeHelper $changeSizeAttributeHelper)
    {
        $this->changeSizeAttributeHelper = $changeSizeAttributeHelper;
    }

    /**
     * @return array
     * @noinspection PhpMissingReturnTypeInspection
     */
    public function toOptionArray()
    {
        $options = $this->changeSizeAttributeHelper->getAllResolutionOptions();

        $output = [];

        foreach ($options as $option) {
            $output [] = [
                'value' => $option->getValue(),
                'label' => $option->getLabel()
            ];
        }

        return $output;
    }

}
