<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 24/02/20
 * Time: 8.22
 */

namespace FiloBlu\Rma\Model;

use Exception;
use FiloBlu\Rma\Api\ChangeSizeRepositoryInterface;
use FiloBlu\Rma\Model\ResourceModel\ChangeSize;
use FiloBlu\Rma\Model\ResourceModel\Carrier\ChangeSize\CollectionFactory;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResultsInterface;
use Magento\Framework\Api\SearchResultsInterfaceFactory;
use Magento\Framework\Exception\NoSuchEntityException;
use Psr\Log\LoggerInterface;
use Throwable;

/**
 *
 */
class ChangeSizeRepository implements ChangeSizeRepositoryInterface
{
    /**
     * @var ChangeSizeFactory
     */
    private $changeSizeFactory;
    /**
     * @var ChangeSize
     */
    private $resourceModel;
    /**
     * @var LoggerInterface
     */
    private $logger;
    /**
     * @var CollectionFactory
     */
    private $collectionFactory;
    /**
     * @var SearchResultsInterfaceFactory
     */
    private $searchResultsInterfaceFactory;


    /**
     * $changeSizeRepository constructor.
     * @param ChangeSizeFactory $changeSizeFactory
     * @param ChangeSize $resourceModel
     * @param LoggerInterface $logger
     * @param CollectionFactory $collectionFactory
     * @param SearchResultsInterfaceFactory $searchResultsInterfaceFactory
     */
    public function __construct(
        ChangeSizeFactory $changeSizeFactory,
        ChangeSize $resourceModel,
        LoggerInterface $logger,
        CollectionFactory $collectionFactory,
        SearchResultsInterfaceFactory $searchResultsInterfaceFactory
    ) {
        $this->changeSizeFactory = $changeSizeFactory;
        $this->resourceModel = $resourceModel;
        $this->logger = $logger;
        $this->collectionFactory = $collectionFactory;
        $this->searchResultsInterfaceFactory = $searchResultsInterfaceFactory;
    }


    /**
     * @param ChangeSizeMatrixRate $changeSize
     */
    public function save(ChangeSizeMatrixRate $changeSize)
    {
        try {
            $this->resourceModel->save($changeSize);
        } catch (Exception $e) {
            $this->logger->critical($e->getMessage(), ['exception' => $e]);
        } catch (Throwable $t) {
            $this->logger->critical($t->getMessage(), ['exception' => $t]);
        }
    }

    /**
     * @param int $rmaEntityId
     * @return ChangeSizeMatrixRate
     */
    public function getByRmaId(int $rmaEntityId)
    {
        $changeSizeCollection = $this->collectionFactory->create()->addFieldToFilter('rma_entity_id', $rmaEntityId);
        $dataModel = $changeSizeCollection->getFirstItem();
        if (count($changeSizeCollection->getItems()) > 1) {
            $this->logger->critical("Multiple values found in changeSize Collection with rma_entity_id = $rmaEntityId");
        }
        return $this->changeSizeFactory->create()->setData($dataModel->getData());
    }

    /**
     * @param int $changeSizeEntityId
     * @return void
     * @throws Exception
     */
    public function deleteById(int $changeSizeEntityId)
    {
        $changeSizeData = $this->collectionFactory->create()->getItemById($changeSizeEntityId);
        if (!$changeSizeData) {
            throw new NoSuchEntityException(__('Requested product does not exist'));
        }
        $changeSize = $this->changeSizeFactory->create()->setData($changeSizeData);
        $this->delete($changeSize);
    }

    /**
     * @param ChangeSizeMatrixRate $changeSize
     * @return void
     * @throws Exception
     */
    public function delete(ChangeSizeMatrixRate $changeSize)
    {
        $this->resourceModel->delete($changeSize);
    }

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResultsInterface
     */
    public function getList(SearchCriteriaInterface $searchCriteria)
    {
        $collection = $this->collectionFactory->create()->addFieldToSelect('*');

        $searchResult = $this->searchResultsInterfaceFactory->create();
        $searchResult->setSearchCriteria($searchCriteria);
        $searchResult->setItems($collection->getItems());
        $searchResult->setTotalCount($collection->getSize());
        return $searchResult;
    }

}
