<?php
declare(strict_types=1);

namespace FiloBlu\Rma\Helper;

use Magento\Framework\App\Helper\AbstractHelper;

class BundlesHelper extends AbstractHelper
{
    /** @var string  */
    const XML_PATH_ALLOW_CART_RULE_APPPLICATION_ON_SHIPPED_SEPARATELY_ITEMS = 'filoblu_disablerma_section/bundles/allow_cart_rule_application_on_shipped_separately_items';
    /** @var string  */
    const XML_PATH_ALLOW_SHIPPED_SEPARATELY_ITEMS_MARKED_AS_SHIPPED = 'filoblu_disablerma_section/bundles/allow_shipped_separately_items_marked_as_shipped';

    /**
     * @return mixed
     */
    public function isAllowCartRuleApplicationOnShippedSeparatelyItems(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_ALLOW_CART_RULE_APPPLICATION_ON_SHIPPED_SEPARATELY_ITEMS);
    }

    /**
     * @return bool
     */
    public function isAllowShippedSeparatelyItemsMarkedAsShipped(): bool
    {
        return $this->scopeConfig->isSetFlag(self::XML_PATH_ALLOW_SHIPPED_SEPARATELY_ITEMS_MARKED_AS_SHIPPED);
    }

}
