<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;


use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\Config;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;

/**
 *
 */
class WrongOrDamagedItemMapping extends AbstractFieldArray
{
    /**
     * @var Config
     */
    private $eavConfig;

    /**
     * @param Context $context
     * @param Config $eavConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        Config $eavConfig,
        array $data = []
    )
    {
        parent::__construct($context, $data);
        $this->eavConfig = $eavConfig;
    }

    /**
     * @var array
     */
    protected $brandReasons;

    /**
     * @var array
     */
    protected $magentoReasons;

    /**
     * Prepare rendering the new field by adding all the needed columns
     *
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $this->addColumn(
            'magento_reason',
            [
                'label' => __('Magento Reason'),
                'renderer' => $this->_getMagentoReasonsRender(),
            ]
        );
        $this->addColumn(
            'brand_reason',
            [
                'label' => __('Brand Reason'),
                'renderer' => $this->_getBrandReasonsRender(),
            ]
        );

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add reason to map');
    }

    /**
     * @return array|\Magento\Framework\View\Element\BlockInterface|\Magento\Framework\View\Element\Html\Select|(\Magento\Framework\View\Element\Html\Select&\Magento\Framework\View\Element\BlockInterface)
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    private function _getBrandReasonsRender()
    {
        if (!$this->brandReasons) {
            $this->brandReasons = $this->getLayout()->createBlock(
                Select::class
            );
        }

        $options = [
            [
                'value' => 'wrong_item',
                'label' => __('Wrong Item')
            ],
            [
                'value' => 'damaged_item',
                'label' => __('Damaged Item')
            ]
        ];

        array_unshift($options, ['value' => '*', 'label' => __('-- Select --')]);


        $this->brandReasons->setOptions($options);
        $this->brandReasons
            ->setId($this->_getCellInputElementId('<%- _id %>', 'brand_reason'))
            ->setName($this->_getCellInputElementName('brand_reason'));

        return $this->brandReasons;
    }


    /**
     * @return array|\Magento\Framework\View\Element\BlockInterface|\Magento\Framework\View\Element\Html\Select|(\Magento\Framework\View\Element\Html\Select&\Magento\Framework\View\Element\BlockInterface)
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    private function _getMagentoReasonsRender()
    {
        if (!$this->magentoReasons) {
            $this->magentoReasons = $this->getLayout()->createBlock(Select::class);
        }

        $options = [];
        $attribute = $this->eavConfig->getAttribute('rma_item', 'reason');

        if($attribute !== null ){
            $options = $attribute->getSource()->getAllOptions();
        }

        array_unshift($options, ['value' => '*', 'label' => __('-- Select --')]);

        $this->magentoReasons->setOptions($options);
        $this->magentoReasons
            ->setId($this->_getCellInputElementId('<%- _id %>', 'magento_reason'))
            ->setName($this->_getCellInputElementName('magento_reason'));

        return $this->magentoReasons;
    }

}
