<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;

use FiloBlu\Rma\Block\Adminhtml\Form\Field\CustomerGroupPolicyColumn;
use FiloBlu\Rma\Model\Config\Source\RmaCreationPolicies;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Customer\Model\ResourceModel\Group\CollectionFactory;
use Magento\Eav\Model\Config;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\BlockInterface;
use Magento\Framework\View\Element\Html\Select;
use Magento\Rma\Model\RmaFactory;


/**
 *
 */
class RmaItemReasonPolicies extends AbstractFieldArray
{
    /**
     * @var BlockInterface|Select|(Select&BlockInterface)
     */
    private $returnCost;
    /**
     * @var BlockInterface|Select|(Select&BlockInterface)
     */
    private $reasonRenderer;
    /**
     * @var Config
     */
    private $eavConfig;

    /**
     * DynamicRow constructor.
     * @param Context $context
     * @param array $data
     */
    public function __construct(
        Context                   $context,
        Config $eavConfig,
        array $data = []
    ) {
        parent::__construct($context, $data);

        $this->eavConfig = $eavConfig;
    }

    /**
     * Prepare rendering the new field by adding all the needed columns
     *
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $this->addColumn(
            'rma_item_reason',
            [
                'label' => __('Rma Item Reason'),
                'renderer' => $this->getReasonRenderer(),
            ]
        );


        $this->addColumn(
            'return_cost',
            [
                'label' => __('Return Cost'),
                'renderer' => $this->getReturnCostRenderer(),
            ]
        );

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add Policy');
    }

    private function getReasonRenderer()
    {
        if (!$this->reasonRenderer) {
            $select = $this->getLayout()->createBlock(
                Select::class,
                '',
                ['data' => []]
            );

            $attribute = $this->eavConfig->getAttribute('rma_item', 'reason');
            $options = [];

            if ($attribute !== null) {
                $options = $attribute->getSource()->getAllOptions();
            }

            $reasonOptions = [];

            foreach ($options as $option) {
                if (!empty($option['value'])) {
                    $reasonOptions[] = ['value' => $option['value'], 'label' => $option['label']];
                }
            }

            array_unshift($reasonOptions, ['value' => '*', 'label' => __('-- Select --')]);

            $select->setOptions($reasonOptions)
                ->setId($this->_getCellInputElementId('<%- _id %>', 'rma_item_reason'))
                ->setName($this->_getCellInputElementName('rma_item_reason'))
                ->setClass('select');

            $this->reasonRenderer = $select;
        }

        return $this->reasonRenderer;
    }

    /**
     * Retrieve the renderer for the "rma_cost" field
     *
     * @return Select
     * @throws LocalizedException
     */
    protected function getReturnCostRenderer()
    {
        if (!$this->returnCost) {

            $select = $this->getLayout()->createBlock(
                Select::class,
                '',
                ['data' => []]
            );

            $options = [
                [
                    'value' => 0,
                    'label' => __('No')
                ],
                [
                    'value' => 1,
                    'label' => __('Yes')
                ]
            ];

            $select
                ->setOptions($options)
                ->setId($this->_getCellInputElementId('<%- _id %>', 'return_cost'))
                ->setName($this->_getCellInputElementName('return_cost'))
                ->setClass('select');

            $this->returnCost = $select;
        }

        return $this->returnCost;
    }
}
