<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\Config;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;
use Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory;

/**
 *
 */
class PickupInStoreAllowedStatuses extends AbstractFieldArray
{
    /**
     * @var Config $eavConfig ,
     */
    protected $eavConfig;

    /**
     * @var CollectionFactory
     */
    private $orderStatusCollectionFactory;

    /**
     * OrderStatus constructor.
     * @param Config $eavConfig
     * @param Context $context
     * @param CollectionFactory $orderStatusCollectionFactory
     * @param array $data
     */
    public function __construct(
        Config            $eavConfig,
        Context           $context,
        CollectionFactory $orderStatusCollectionFactory,
        array             $data = []
    )
    {
        parent::__construct($context, $data);
        $this->orderStatusCollectionFactory = $orderStatusCollectionFactory;
        $this->eavConfig = $eavConfig;
    }

    /**
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $orderStatus = $this->orderStatusCollectionFactory->create()->toOptionArray();

        array_unshift($orderStatus, ['value' => '*', 'label' => __('-- Select --')]);

        $orderStatusBlock = $this->getLayout()
            ->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'pickupinstore_allowed_status'))
            ->setName($this->_getCellInputElementName('pickupinstore_allowed_status'))
            ->setClass('select')
            ->setOptions($orderStatus);

        $this->addColumn('pickupinstore_allowed_status', [
            'label' => __('Magento Order Status'),
            'renderer' => $orderStatusBlock
        ]);

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add new PickupInStore allowed order status');
    }

}
