<?php

namespace FiloBlu\Rma\Block\Adminhtml\Rma;

use FiloBlu\Rma\Block\Adminhtml\Rma\Grid\Renderer\RmaType;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Helper\Data;
use Magento\Rma\Model\ResourceModel\Rma\Grid\CollectionFactory;
use Magento\Rma\Model\RmaFactory;

/**
 *
 */
class Grid extends \Magento\Rma\Block\Adminhtml\Rma\Grid
{
    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Backend\Helper\Data $backendHelper
     * @param \Magento\Rma\Model\ResourceModel\Rma\Grid\CollectionFactory $collectionFactory
     * @param \Magento\Rma\Model\RmaFactory $rmaFactory
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $backendHelper,
        CollectionFactory $collectionFactory,
        RmaFactory $rmaFactory,
        array $data = []
    ) {
        parent::__construct($context, $backendHelper, $collectionFactory, $rmaFactory, $data);
    }

    /**
     * Prepare grid columns
     *
     * @return \Magento\Rma\Block\Adminhtml\Rma\Grid
     */
    protected function _prepareColumns()
    {
        $this->addColumn(
            'increment_id',
            [
                'header'           => __('RMA'),
                'index'            => 'increment_id',
                'type'             => 'text',
                'header_css_class' => 'col-rma-number',
                'column_css_class' => 'col-rma-number'
            ]
        );

        $this->addColumn(
            'date_requested',
            [
                'header'           => __('Requested'),
                'index'            => 'date_requested',
                'type'             => 'datetime',
                'html_decorators'  => ['nobr'],
                'header_css_class' => 'col-period',
                'column_css_class' => 'col-period'
            ]
        );

        $this->addColumn(
            'order_increment_id',
            [
                'header'           => __('Order'),
                'type'             => 'text',
                'index'            => 'order_increment_id',
                'header_css_class' => 'col-order-number',
                'column_css_class' => 'col-order-number'
            ]
        );

        $this->addColumn(
            'order_date',
            [
                'header'           => __('Ordered'),
                'index'            => 'order_date',
                'type'             => 'datetime',
                'html_decorators'  => ['nobr'],
                'header_css_class' => 'col-period',
                'column_css_class' => 'col-period'
            ]
        );

        $this->addColumn(
            'customer_name',
            [
                'header'           => __('Customer'),
                'index'            => 'customer_name',
                'header_css_class' => 'col-name',
                'column_css_class' => 'col-name'
            ]
        );
        /** @var \Magento\Rma\Model\Rma $rmaModel */
        $rmaModel = $this->_rmaFactory->create();
        $this->addColumn(
            'status',
            [
                'header'           => __('Status'),
                'index'            => 'status',
                'type'             => 'options',
                'options'          => $rmaModel->getAllStatuses(),
                'header_css_class' => 'col-status',
                'column_css_class' => 'col-status'
            ]
        );

        $this->addColumnAfter(
            'rma_type',
            [
                'header'   => __('Rma Type'),
                'index'    => 'rma_type',
                'renderer' => RmaType::class
            ],
            'status'
        );

        $this->addColumn(
            'action',
            [
                'header'           => __('Action'),
                'type'             => 'action',
                'getter'           => 'getId',
                'actions'          => [
                    [
                        'caption' => __('View'),
                        'url'     => ['base' => $this->_getControllerUrl('edit')],
                        'field'   => 'id',
                    ],
                ],
                'filter'           => false,
                'sortable'         => false,
                'index'            => 'stores',
                'is_system'        => true,
                'header_css_class' => 'col-actions',
                'column_css_class' => 'col-actions'
            ]
        );

        return parent::_prepareColumns();
    }
}
