<?php

namespace FiloBlu\Rma\Block\Adminhtml\Rma\Edit\Tab;

use Exception;
use FiloBlu\Rma\Api\EasyReturnRepositoryInterface;
use FiloBlu\Rma\Helper\EasyReturnHelper;
use Magento\Backend\Block\Template\Context;
use Magento\Directory\Model\RegionFactory;
use Magento\Framework\Data\FormFactory;
use Magento\Framework\Registry;
use Magento\Rma\Api\RmaRepositoryInterface;
use Magento\Rma\Model\Rma;
use Magento\Sales\Api\Data\OrderAddressInterface;
use Throwable;

/**
 *
 */
class General extends \Magento\Rma\Block\Adminhtml\Rma\Edit\Tab\General
{
    /**
     * @var EasyReturnRepositoryInterface
     */
    private $easyReturnRepository;
    /**
     * @var RegionFactory
     */
    private $regionFactory;
    /**
     * @var EasyReturnHelper
     */
    private $easyReturnHelper;
    /**
     * @var RmaRepositoryInterface
     */
    private $rmaRepository;

    /**
     * General constructor.
     * @param Context $context
     * @param Registry $registry
     * @param FormFactory $formFactory
     * @param EasyReturnRepositoryInterface $easyReturnRepository
     * @param RegionFactory $regionFactory
     * @param EasyReturnHelper $easyReturnHelper
     * @param RmaRepositoryInterface $rmaRepository
     * @param array $data
     */
    public function __construct(
        Context                       $context,
        Registry                      $registry,
        FormFactory                   $formFactory,
        EasyReturnRepositoryInterface $easyReturnRepository,
        RegionFactory                 $regionFactory,
        EasyReturnHelper              $easyReturnHelper,
        RmaRepositoryInterface        $rmaRepository,
        array                         $data = [])
    {
        parent::__construct($context, $registry, $formFactory, $data);
        $this->easyReturnRepository = $easyReturnRepository;
        $this->regionFactory = $regionFactory;
        $this->easyReturnHelper = $easyReturnHelper;
        $this->rmaRepository = $rmaRepository;
    }


    /**
     * @return OrderAddressInterface|null
     */
    public function getPickupAddress()
    {
        try {
            /** @var Rma $rma */
            $rmaId = $this->getRequest()->getParam('id');
            $rma =  $this->rmaRepository->get($rmaId);
            $easyReturn = $this->easyReturnRepository->getByRmaId($rmaId);
            if ($easyReturn) {
                if ($easyReturn->getRegionId()) {
                    $regionName = $this->regionFactory->create()->load($easyReturn->getRegionId());
                    $easyReturn->setRegion($regionName->getName());
                }

                return $this->easyReturnHelper->checkPickupAddress($easyReturn->getPickUpAddress(), $rma->getOrder());
            }
        } catch (Exception $exception) {
            $this->_logger->critical($exception->getMessage(), ['exception' => $exception]);
        } catch (Throwable $throwable) {
            $this->_logger->critical($throwable->getMessage(), ['exception' => $throwable]);
        }

        return null;
    }
}
