<?php

namespace FiloBlu\Rma\Block\Adminhtml\Order\Creditmemo\Create;

use FiloBlu\Rma\Helper\RefundParentOrderHelper;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Button;
use Magento\CatalogInventory\Api\StockConfigurationInterface;
use Magento\CatalogInventory\Api\StockRegistryInterface;
use Magento\Framework\Registry;
use Magento\Sales\Helper\Data;

/**
 *
 */
class Items extends \Magento\Sales\Block\Adminhtml\Order\Creditmemo\Create\Items
{
    /**
     * @var RefundParentOrderHelper
     */
    private $refundHelper;

    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\CatalogInventory\Api\StockRegistryInterface $stockRegistry
     * @param \Magento\CatalogInventory\Api\StockConfigurationInterface $stockConfiguration
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Sales\Helper\Data $salesData
     * @param \FiloBlu\Rma\Helper\RefundParentOrderHelper $refundHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        StockRegistryInterface $stockRegistry,
        StockConfigurationInterface $stockConfiguration,
        Registry $registry,
        Data $salesData,
        RefundParentOrderHelper $refundHelper,
        array $data = []
    ) {
        parent::__construct($context, $stockRegistry, $stockConfiguration, $registry, $salesData, $data);
        $this->refundHelper = $refundHelper;
    }

    /**
     * Prepare child blocks
     *
     * @return $this
     */
    protected function _prepareLayout()
    {
        $order = $this->getOrder();
        $payment = $order->getPayment();
        $refundParentOrder = false;
        if ($payment->getMethod() === 'changesizepay') {
            $parentPayment = $this->refundHelper->getParentOrderPayment($payment);
            if ($this->refundHelper->isOnlinePaymentRefundForParentEnabled() && $this->refundHelper->isOrderAllowedToRefund($payment, $parentPayment)) {
                $refundParentOrder = true;
            }
        }

        if ($refundParentOrder) {
            $onclick = "submitAndReloadArea($('creditmemo_item_container'),'" . $this->getUpdateUrl() . "')";
            $this->addChild(
                'update_button',
                Button::class,
                ['label' => __('Update Qty\'s'), 'class' => 'update-button', 'onclick' => $onclick]
            );

            $this->addChild(
                'submit_button',
                Button::class,
                [
                    'label' => __('Refund'),
                    'class' => 'save submit-button refund primary',
                    'onclick' => 'disableElements(\'submit-button\');submitCreditMemo()'
                ]
            );

            $this->addChild(
                'submit_offline',
                Button::class,
                [
                    'label' => __('Refund Offline'),
                    'class' => 'save submit-button primary',
                    'onclick' => 'disableElements(\'submit-button\');submitCreditMemoOffline()'
                ]
            );

            return $this;
        }

        return parent::_prepareLayout();
    }
}
