<?php

namespace FiloBlu\Rma\Block\Adminhtml\Carrier\Matrixrate;

use FiloBlu\Rma\Model\Carrier\CarrierRate;
use FiloBlu\Rma\Model\ResourceModel\Carrier\EasyReturnRate\Collection;
use FiloBlu\Rma\Model\ResourceModel\Carrier\EasyReturnRate\CollectionFactory;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Block\Widget\Grid\Extended;
use Magento\Backend\Helper\Data;
use Magento\Framework\Exception\FileSystemException;
use Magento\Framework\Exception\LocalizedException;

/**
 *
 */
class EasyReturnGrid extends Extended
{
    /**
     * Website filter
     *
     * @var int
     */
    protected $websiteId;

    /**
     * Condition filter
     *
     * @var string
     */
    protected $conditionName;

    /**
     * @var CarrierRate
     */
    protected $matrixRate;

    /**
     * @var CollectionFactory
     */
    protected $collectionFactory;

    /**
     * Grid constructor.
     * @param Context $context
     * @param Data $backendHelper
     * @param CollectionFactory $collectionFactory
     * @param CarrierRate $matrixRate
     * @param array $data
     */
    public function __construct(
        Context $context,
        Data $backendHelper,
        CollectionFactory $collectionFactory,
        CarrierRate $matrixRate,
        array $data = []
    ) {
        parent::__construct($context, $backendHelper, $data);
        $this->collectionFactory = $collectionFactory;
        $this->matrixRate = $matrixRate;
    }

    /**
     * Define grid properties
     *
     * @return void
     * @throws FileSystemException
     * @noinspection MagicMethodsValidityInspection
     */
    protected function _construct()
    {
        parent::_construct();
        $this->setId('shippingMatrixrateGrid');
        $this->_exportPageSize = 10000;
    }

    /**
     * @return Extended
     * @throws LocalizedException
     */
    protected function _prepareCollection()
    {
        /** @var Collection $collection */
        $collection = $this->collectionFactory->create();
        $collection->setConditionFilter($this->getConditionName())->setWebsiteFilter($this->getWebsiteId());

        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    /**
     * Retrieve current website id
     *
     * @return int
     */
    public function getConditionName()
    {
        return $this->conditionName;
    }

    /**
     * Set current website
     *
     * @param string $name
     * @return $this
     */
    public function setConditionName($name)
    {
        $this->conditionName = $name;
        return $this;
    }

    /**
     * @return int
     * @throws LocalizedException
     */
    public function getWebsiteId()
    {
        if ($this->websiteId === null) {
            $this->websiteId = $this->_storeManager->getWebsite()->getId();
        }
        return $this->websiteId;
    }

    /**
     * @param $websiteId
     * @return $this
     * @throws LocalizedException
     */
    public function setWebsiteId($websiteId)
    {
        $this->websiteId = $this->_storeManager->getWebsite($websiteId)->getId();
        return $this;
    }

    /**
     * @return Extended
     * @throws LocalizedException
     */
    protected function _prepareColumns()
    {
        $this->addColumn(
            'dest_country_id', ['header' => __('Country'), 'index' => 'dest_country_id', 'default' => '*']
        );

        $this->addColumn(
            'dest_region_id', ['header' => __('Region/State'), 'index' => 'dest_region_id', 'default' => '*']
        );
        $this->addColumn(
            'dest_city', ['header' => __('City'), 'index' => 'dest_city', 'default' => '*']
        );
        $this->addColumn(
            'dest_zip', ['header' => __('Zip/Postal Code From'), 'index' => 'dest_zip', 'default' => '*']
        );
        $this->addColumn(
            'dest_zip_to', ['header' => __('Zip/Postal Code To'), 'index' => 'dest_zip_to', 'default' => '*']
        );

        $this->addColumn(
            'condition_name', ['header' => __('Condition Name'), 'index' => 'condition_name', 'default' => '*']
        );

        $label = $this->matrixRate->getCode('condition_name_short', $this->getConditionName());

        $this->addColumn(
            'condition_from_value', ['header' => $label . __('>'), 'index' => 'condition_from_value']
        );

        $this->addColumn(
            'condition_to_value', ['header' => $label . __('<='), 'index' => 'condition_to_value']
        );

        $this->addColumn('price', ['header' => __('Shipping Price'), 'index' => 'price']);

        $this->addColumn(
            'cost', ['header' => __('Cost'), 'index' => 'cost']
        );

        $this->addColumn(
            'shipping_method', ['header' => __('Shipping Method'), 'index' => 'shipping_method']
        );

        return parent::_prepareColumns();
    }
}
