<?php
namespace FiloBlu\Rma\Api\Data;

/**
 *
 */
interface EasyReturnInterface
{
    /**
     * Constants defined for keys of the data array. Identical to the name of the getter in snake case
     */
    const ID = 'entity_id';
    const FIRSTNAME = 'customer_firstname';
    const LASTNAME = 'customer_lastname';
    const RMA_ENTITY_ID = 'rma_entity_id';
    const STREET = 'street';
    const CITY = 'city';
    const REGION_ID  ='region_id';
    const REGION = 'region';
    const POSTCODE = 'postcode';
    const COUNTRY_ID = 'country_id';
    const THEORIC_SHIPPING_AMOUNT = 'theoric_shipping_amount';
    const TELEPHONE ='telephone';

    /**
     * @return int
     */
    public function getId();

    /**
     * @param string $firstname
     * @return $this
     */
    public function setFirstName(string $firstname);

    /**
     * @return string
     */
    public function getFirstName();

    /**
     * @param string $lastname
     * @return $this
     */
    public function setLastName(string $lastname);

    /**
     * @return string
     */
    public function getLastName();

    /**
     * @param int $rmaEntityId
     * @return $this
     */
    public function setRmaEntityId(int $rmaEntityId);

    /**
     * @return int
     */
    public function getRmaEntityId();

    /**
     * @param string $street
     * @return $this
     */
    public function setStreet(string $street);

    /**
     * @return string
     */
    public function getTelephone();

    /**
     * @param string $telephone
     * @return mixed
     */
    public function setTelephone(string $telephone);

    /**
     * @return string
     */
    public function getStreet();

    /**
     * @param string $city
     * @return $this
     */
    public function setCity(string $city);

    /**
     * @return string
     */
    public function getCity();

    /**
     * @param int $regionId
     * @return $this
     */
    public function setRegionId(int $regionId);

    /**
     * @return int
     */
    public function getRegionId();

    /**
     * @param string $region
     * @return $this
     */
    public function setRegion(string $region);

    /**
     * @return string
     */
    public function getRegion();

    /**
     * @param string $postcode
     * @return $this
     */
    public function setPostcode(string $postcode);

    /**
     * @return string
     */
    public function getPostcode();

    /**
     * @param string $countryId
     * @return $this
     */
    public function setCountryId(string $countryId);

    /**
     * @return string
     */
    public function getCountryId();

    /**
     * @param float $amount
     * @return $this
     */
    public function setTheoricShippingAmount(float $amount);

    /**
     * @return float
     */
    public function getTheoricShippingAmount();

    /**
     * @return \Magento\Sales\Api\Data\OrderAddressInterface
     */
    public function getPickUpAddress();

    /**
     * @param array $data
     * @return \FiloBlu\Rma\Model\EasyReturn
     */
    public function setEasyReturnData(array $data);

    /**
     *
     * @param mixed $data
     * @return mixed
     */
    public function estimateReturnShippingCost($data);

}
