require([
    'jquery',
    'Magento_Ui/js/modal/alert'
], function ($, alert) {
    $(function () {
        function overrideRma() {
            if (typeof window.rma !== 'undefined' && typeof window.rma.addSelectedProduct === 'function') {
                const originalFn = window.rma.addSelectedProduct;

                window.rma.addSelectedProduct = function () {

                    if ($('.rma-popup').length === 0) {
                        return originalFn.apply(this, arguments);
                    }

                    if ($('.rma-popup').is(':visible')) {
                        if ($('.rma-popup input[type="checkbox"]:checked').length > 0) {
                            alert({
                                'title': 'Warning',
                                'content': 'Please confirm the selection of bundle products by clicking the OK at bottom of page.',
                                actions: {
                                    always: function(){}
                                }

                            });
                            return;
                        }
                    }

                    // ✅ Aggiungi i tuoi controlli qui
                    if ($('.rma-popup input[type="checkbox"]:checked').length === 0) {
                        alert({
                            'title': 'Warning',
                            'content': 'Please select at least one product from the bundle before continuing.',
                            actions: {
                                always: function(){}
                            }

                        });
                        return;
                    }

                    // Prosegui con il comportamento originale
                    return originalFn.apply(this, arguments);
                };
            } else {
                setTimeout(overrideRma, 300); // ⏳ Retry finché non viene definito
            }
        }

        overrideRma();
    });
});
