<?php

namespace FiloBlu\Rma\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use FiloBlu\Rma\Model\RmaManagement;
use Magento\Rma\Model\RmaFactory;
use Magento\Rma\Model\ItemFactory;

class GetReturnTypes extends Action
{

	protected $rmaManagement;
    protected $rmaFactory;
    protected $itemFactory;
	protected $resultJsonFactory;

    public function __construct(
        Context $context,
		RmaManagement $rmaManagement,
		RmaFactory $rmaFactory,
		ItemFactory $itemFactory,
		\Magento\Framework\Controller\Result\JsonFactory $resultJsonFactory
    ) {
		parent::__construct($context);
		$this->rmaManagement = $rmaManagement;
		$this->rmaFactory = $rmaFactory;
		$this->itemFactory = $itemFactory;
		$this->resultJsonFactory = $resultJsonFactory;
    }

    public function execute()
    {
		$items = $this->getRequest()->getParam('items');
		$rma = $this->rmaFactory->create();
		$rmaItems = [];
		
		foreach ($items as $item) {
			$rmaItem = $this->itemFactory->create();
			$rmaItem->setOrderItemId($item["order_item_id"]);
			$rmaItem->setResolution($item["resolution"]);
			$rmaItems[] = $rmaItem;
		}
		
		$rma->setItems($rmaItems);

		$result = $this->rmaManagement->getReturnTypes($rma);
		$resultJson = $this->resultJsonFactory->create();

		return $resultJson->setData($result);
	}
}
