<?php
/**
 * Created by PhpStorm.
 * User: jderosa
 * Date: 21/02/20
 * Time: 11.57
 */

namespace FiloBlu\Rma\Setup;

use FiloBlu\Rma\Api\RmaExtensionAttributesRepositoryInterface;
use Magento\Framework\DB\Ddl\Table;
use Magento\Framework\Setup\InstallSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Zend_Db_Exception;

/**
 *
 */
class InstallSchema implements InstallSchemaInterface
{
    /**
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @throws Zend_Db_Exception
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $setup->getConnection()
            ->newTable($setup->getTable(RmaExtensionAttributesRepositoryInterface::TABLE_NAME))
            ->addColumn(
                'id',
                Table::TYPE_INTEGER,
                null,
                ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true],
                'id')
            ->addColumn('rma_item_id',
                Table::TYPE_INTEGER,
                null,
                ['unsigned' => true, 'nullable' => false],
                'rma_entity_id')
            ->addColumn('order_id',
                Table::TYPE_INTEGER,
                null,
                ['unsigned' => true, 'nullable' => false],
                'order_id');
        $setup->endSetup();
    }

}
