<?php

namespace FiloBlu\Rma\Plugin\Rma\Adminhtml;

use FiloBlu\Rma\Helper\ChangeSizeHelper;
use Magento\Framework\App\RequestInterface;
use Magento\Sales\Model\OrderRepository;

/**
 *
 */
class Grid
{
    /**
     * @var ChangeSizeHelper
     */
    protected $changeSizeHelper;
    /**
     * @var OrderRepository
     */
    private $orderRepository;
    /**
     * @var RequestInterface
     */
    private $request;

    /**
     * @param ChangeSizeHelper $changeSizeHelper
     * @param OrderRepository $orderRepository
     * @param RequestInterface $request
     */
    public function __construct(
        ChangeSizeHelper $changeSizeHelper,
        OrderRepository  $orderRepository,
        RequestInterface $request

    )
    {
        $this->changeSizeHelper = $changeSizeHelper;
        $this->orderRepository = $orderRepository;
        $this->request = $request;
    }

    /**
     * @param $subject
     * @param $form
     * @return null
     */
    public function beforeSetForm($subject, $form)
    {
        if ($form->getData('html_id_prefix') !== 'rma_properties_') {
            return null;
        }

        $orderId = $this->request->getParam('order_id');

        if (empty($orderId)) {
            return null;
        }

        $order = $this->orderRepository->get($orderId);
        $fieldset = $form->getElement('rma_item_fields');

        if (empty($fieldset)) {
            return null;
        }

        if (!$this->changeSizeHelper->isChangeSizeEnabled($order->getStoreId())) {
            return null;
        }

        $fieldset->addField(
            'changesize',
            'select',
            [
                'label' => __('Change Size'),
                'options' => ['' => ''],
                'name' => 'changesize',
                'required' => false
            ]
        );

        return null;
    }
}
