<?php

namespace FiloBlu\Rma\Plugin\Model\Rma;


use FiloBlu\Rma\Helper\RmaItemResolutionHistoryHelper;

/**
 *
 */
class Item
{
    /**
     * @var RmaItemResolutionHistoryHelper
     */
    private $rmaItemResolutionHistoryHelper;

    /**
     * @param RmaItemResolutionHistoryHelper $rmaItemResolutionHistoryHelper
     */
    public function __construct(
        RmaItemResolutionHistoryHelper $rmaItemResolutionHistoryHelper
    )
    {
        $this->rmaItemResolutionHistoryHelper = $rmaItemResolutionHistoryHelper;
    }

    /**
     * @param \Magento\Rma\Model\Item $subject
     * @param $result
     * @return mixed
     */
    public function afterSetResolution(\Magento\Rma\Model\Item $subject, $result)
    {
        $this->rmaItemResolutionHistoryHelper->saveData($subject);

        return $result;
    }


    /**
     * @param \Magento\Rma\Model\Item $subject
     * @param $result
     * @return mixed
     */
    public function afterSave(\Magento\Rma\Model\Item $subject, $result)
    {
        return $result;
    }
}
