<?php

namespace FiloBlu\Rma\Model\ResourceModel\Carrier\ChangeSize;

use FiloBlu\Rma\Model\ResourceModel\ChangeSize;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use FiloBlu\Rma\Model\ChangeSizeMatrixRate;

class Collection extends AbstractCollection
{
    /**
     * @return Collection|void
     */
    public function _initSelect()
    {
        parent::_initSelect();
    }

    /**
     * @param $conditionName
     * @return Collection
     */
    public function setConditionFilter($conditionName)
    {
        return $this->addFieldToFilter('condition_name', $conditionName);
    }

    /**
     * Add website filter to collection
     *
     * @param int $websiteId
     * @return Collection
     */
    public function setWebsiteFilter($websiteId)
    {
        return $this->addFieldToFilter('website_id', $websiteId);
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        $this->_init(ChangeSizeMatrixRate::class, ChangeSize::class);
    }
}
