<?php

namespace FiloBlu\Rma\Model\Config\Source;

use Magento\Framework\Data\OptionSourceInterface;
use Magento\Framework\Module\Manager;
use Magento\Framework\ObjectManagerInterface;

/**
 *
 */
class Matrixrate implements OptionSourceInterface
{
    /**
     * @var \Magento\Framework\Module\Manager
     */
    private $moduleManager;
    /**
     * @var \Magento\Framework\ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @param Manager $moduleManager
     * @param \Magento\Framework\ObjectManagerInterface $objectManager
     */
    public function __construct(
        Manager $moduleManager,
        ObjectManagerInterface $objectManager
    ) {
        $this->moduleManager = $moduleManager;
        $this->objectManager = $objectManager;
    }

    /**
     * @return array
     * @throws \Magento\Framework\Exception\LocalizedException
     */
    public function toOptionArray()
    {
        $options = [];
        if ($this->moduleManager->isEnabled('WebShopApps_MatrixRate')) {
            $matrixRate = $this->objectManager->create(\WebShopApps\MatrixRate\Model\Carrier\Matrixrate::class);
            foreach ($matrixRate->getCode('condition_name') as $k => $v) {
                $options[] = ['value' => $k, 'label' => $v];
            }
        } else {
            $options = [
                [
                    'value' => 'package_weight',
                    'label' => __('Weight vs. Destination')
                ],
                [
                    'value' => 'package_value',
                    'label' => __('Order Subtotal vs. Destination')
                ]
            ];
        }

        return $options;
    }
}
