<?php

require __DIR__ . '/../../../../../app/bootstrap.php';

use FiloBlu\Rma\Helper\EasyReturnHelper;
use Magento\Framework\App\Area;
use Magento\Framework\App\Bootstrap;
use Magento\Framework\App\State;
use Magento\Rma\Model\ItemFactory;
use Magento\Sales\Api\OrderRepositoryInterface;

use const Filoblu\Storelocator\Model\Rma\ItemFactory;

$bootstrap = Bootstrap::create(BP, $_SERVER);

$objectManager = $bootstrap->getObjectManager();

/** @var State $state */
$state = $objectManager->get(State::class);
$state->setAreaCode(Area::AREA_FRONTEND);

$helper = $objectManager->get(EasyReturnHelper::class);

/** @var OrderRepositoryInterface $orderRepository */
$orderRepository = $objectManager->get(OrderRepositoryInterface::class);

$order = $orderRepository->get(221724);

$address = $order->getShippingAddress();

$shippingCost = $helper->simulateEasyReturnShippingCost(
    $address,
    $order->getStore(),
    0.2,
    $order->getGrandTotal(),
    22,
    'price'
);
