<?php

namespace FiloBlu\Rma\Block\Adminhtml\Rma\Grid;

use FiloBlu\Rma\Helper\ChangeSizeAttributeHelper;
use FiloBlu\Rma\Helper\ChangeSizeHelper;
use Magento\Backend\Block\Template;
use Magento\Backend\Block\Template\Context;
use Magento\Backend\Model\Url;
use Magento\Framework\App\Request\Http;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Sales\Api\Data\OrderInterface;
use Magento\Sales\Api\OrderRepositoryInterface;
use Magento\Store\Model\StoreManagerInterface;

/**
 *
 */
class Js extends Template
{
    /**
     * @var ChangeSizeAttributeHelper
     */
    private $changeSizeAttributeHelper;
    /**
     * @var Http
     */
    private $request;
    /**
     * @var OrderRepositoryInterface
     */
    private $orderRepository;
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;
    /**
     * @var Url
     */
    private $backendUrlManager;
    /**
     * @var OrderInterface
     */
    protected $order;
    /**
     * @var Json
     */
    private $serializer;

    /**
     * @param Context $context
     * @param ChangeSizeAttributeHelper $changeSizeAttributeHelper
     * @param Http $request
     * @param OrderRepositoryInterface $orderRepository
     * @param StoreManagerInterface $storeManager
     * @param Url $backendUrlManager
     * @param Json $serializer
     * @param array $data
     */
    public function __construct(
        Context                   $context,
        ChangeSizeAttributeHelper $changeSizeAttributeHelper,
        Http                      $request,
        OrderRepositoryInterface  $orderRepository,
        StoreManagerInterface     $storeManager,
        Url                       $backendUrlManager,
        Json                      $serializer,
        array                     $data = []
    )
    {
        parent::__construct($context, $data);
        $this->changeSizeAttributeHelper = $changeSizeAttributeHelper;
        $this->request = $request;
        $this->orderRepository = $orderRepository;
        $this->storeManager = $storeManager;
        $this->backendUrlManager = $backendUrlManager;

        $orderId = $this->request->getParam('order_id');
        $this->order = $this->orderRepository->get($orderId);
        $this->serializer = $serializer;
    }

    /**
     * @return int
     */
    public function getChangeSizeAttributeOptionId()
    {
        return $this->changeSizeAttributeHelper->getChangeSizeAttributeOptionId();
    }

    /**
     * @return int
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getWebsiteId()
    {
        return $this->storeManager->getStore($this->order->getStoreId())->getWebsiteId();
    }

    /**
     * @return string|null
     */
    public function getCustomUrl()
    {
        return $this->backendUrlManager->getUrl();
    }

    /**
     * @return bool
     */
    public function isChangeSizeEnabled()
    {
        return $this->changeSizeAttributeHelper->isChangeSizeEnabled($this->order->getStore()->getWebsiteId());
    }

    public function getOrderItems()
    {
        $orderItems = [];

        foreach ($this->order->getAllVisibleItems() as $item) {
            $orderItems[] = $item->toArray();
        }

        return $this->serializer->serialize($orderItems);
    }

    public function getOrderId()
    {
        return $this->order->getId();
    }
}
