<?php

namespace FiloBlu\Rma\Model;

use FiloBlu\Rma\Api\RmaItemResolutionHistoryInterface;
use FiloBlu\Rma\Model\ResourceModel\RmaItemResolutionHistory\Collection;
use FiloBlu\Rma\Model\ResourceModel\RmaItemResolutionHistory\CollectionFactory;

class RmaItemResolutionHistoryRepository implements RmaItemResolutionHistoryInterface
{
    /**
     * @var CollectionFactory
     */
    protected $collectionFactory;

    /**
     * @param \FiloBlu\Rma\Model\ResourceModel\RmaItemResolutionHistory\CollectionFactory $collectionFactory
     */
    public function __construct(
        CollectionFactory $collectionFactory
    )
    {
        $this->collectionFactory = $collectionFactory;
    }

    /**
     * @param int $itemId
     * @return false|\Magento\Framework\DataObject[]
     */
    public function getByItemId(int $itemId)
    {
        /** @var Collection $collection */
        $collection = $this->collectionFactory->create();
        $collection
            ->addFieldToFilter('item_id', $itemId);

        if (!$collection->count()) {
            return false;
        }

        return $collection->getItems();
    }

    /**
     * @param int $itemId
     * @param string $url
     * @return false|\Magento\Framework\DataObject[]
     */
    public function getByItemIdAndUrl(int $itemId, string $url)
    {
        /** @var Collection $collection */
        $collection = $this->collectionFactory->create();
        $collection
            ->addFieldToFilter('item_id', $itemId)
            ->addFieldToFilter('url', $url);

        if (!$collection->count()) {
            return false;
        }

        return $collection->getItems();
    }
}
