<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;

use FiloBlu\Rma\Api\Model\Config\Reader;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\Config;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;

/**
 *
 */
class ReasonToDisableEmail extends AbstractFieldArray
{

    /**
     * @var Config $eavConfig ,
     */
    protected $eavConfig;

    /**
     * Constructor
     *
     * @param Config $eavConfig
     * @param Context $context
     * @param array $data
     */
    public function __construct(
        Config  $eavConfig,
        Context $context,
        array   $data = []
    ) {
        parent::__construct($context, $data);
        $this->eavConfig = $eavConfig;
    }


    /**
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $options = [];

        $attribute = $this->eavConfig->getAttribute('rma_item', 'reason');

        if($attribute!== null)
        {
            $options = $attribute->getSource()->getAllOptions();
        }

        $brandReasons = [];

        foreach ($options as $option) {
            if ($option['value']) {
                $brandReasons[] = ['value' => $option['value'], 'label' => $option['label']];
            }
        }

        array_unshift($brandReasons, ['value' => '*', 'label' => __('-- Select --')]);

        $rmaResonsBlock = $this->getLayout()->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'rma_reson'))
            ->setName($this->_getCellInputElementName('rma_reson'))
            ->setClass('select')
            ->setOptions($brandReasons);

        $this->addColumn('rma_reson', [
            'label'    => __('Rma Reason'),
            'renderer' => $rmaResonsBlock
        ]);

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add Rma Reason');
    }
}
