<?php

namespace FiloBlu\Rma\Block\Adminhtml\System\Config;

use FiloBlu\Rma\Api\Model\Config\Reader;
use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Eav\Model\Config;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\View\Element\Html\Select;

/**
 *
 */
class Reason extends AbstractFieldArray
{

    /**
     * @var Config $eavConfig ,
     */
    protected $eavConfig;

    /**
     * @var Reader
     */
    private $reader;

    /**
     * Constructor
     *
     * @param Config $eavConfig
     * @param Context $context
     * @param Reader $reader
     * @param array $data
     */
    public function __construct(
        Config  $eavConfig,
        Context $context,
        Reader  $reader,
        array   $data = []
    )
    {
        parent::__construct($context, $data);
        $this->eavConfig = $eavConfig;
        $this->reader = $reader;
    }


    /**
     * @throws LocalizedException
     */
    protected function _prepareToRender()
    {
        $options = [];

        $attribute = $this->eavConfig->getAttribute('rma_item', 'reason');

        if($attribute!== null)
        {
            $options = $attribute->getSource()->getAllOptions();
        }

        $isVisible = [
            ['value' => '*', 'label' => __('-- Select --')],
            ['value' => 0, 'label' => 'No'],
            ['value' => 1, 'label' => 'Yes']
        ];

        $brandReasons = [];
        $standardReasons = [];
        $standardReasonsConfig = $this->reader->read();

        foreach ($standardReasonsConfig as $reason) {
            $standardReasons[] = ['value' => $reason['id'], 'label' => $reason['standard_name']];
        }

        foreach ($options as $option) {
            if ($option['value']) {
                $brandReasons[] = ['value' => $option['value'], 'label' => $option['label']];
            }
        }

        array_unshift($brandReasons, ['value' => '*', 'label' => __('-- Select --')]);
        array_unshift($standardReasons, ['value' => '*', 'label' => __('-- Select --')]);

        $brandReasonsBlock = $this->getLayout()->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'brand_reason'))
            ->setName($this->_getCellInputElementName('brand_reason'))
            ->setClass('select')
            ->setOptions($brandReasons);

        $this->addColumn('brand_reason', [
            'label'    => __('Brand Reason'),
            'renderer' => $brandReasonsBlock
        ]);

        $standardReasonsBlock = $this->getLayout()
            ->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'standard_reason'))
            ->setName($this->_getCellInputElementName('standard_reason'))
            ->setClass('select')
            ->setOptions($standardReasons);

        $isVisibleBlock = $this->getLayout()
            ->createBlock(Select::class)
            ->setId($this->_getCellInputElementId('<%- _id %>', 'is_visible'))
            ->setName($this->_getCellInputElementName('is_visible'))
            ->setClass('select')
            ->setOptions($isVisible);

        $this->addColumn('standard_reason', [
            'label'    => __('Standard Reason'),
            'renderer' => $standardReasonsBlock
        ]);

        $this->addColumn('is_visibile', [
            'label'    => __('Visible At FE'),
            'renderer' => $isVisibleBlock
        ]);

        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add new mapping');
    }
}
