<?php

namespace FiloBlu\Rma\Block\Adminhtml\Rma\Grid\Renderer;

use FiloBlu\Rma\Helper\EasyReturnHelper;
use Magento\Backend\Block\Context;
use Magento\Backend\Block\Widget\Grid\Column\Renderer\Text;
use Magento\Framework\DataObject;

/**
 *
 */
class RmaType extends Text
{
    /**
     * @var EasyReturnHelper
     */
    protected $easyReturnHelper;

    /**
     * @param \Magento\Backend\Block\Context $context
     * @param \FiloBlu\Rma\Helper\EasyReturnHelper $easyReturnHelper
     * @param array $data
     */
    public function __construct(
        Context $context,
        EasyReturnHelper $easyReturnHelper,
        array $data = []
    ) {
        parent::__construct($context, $data);
        $this->easyReturnHelper = $easyReturnHelper;
    }

    /**
     * @param \Magento\Framework\DataObject $row
     * @return \Magento\Framework\Phrase
     */
    public function render(DataObject $row)
    {
        if (!$this->easyReturnHelper->isEasyReturn($row->getEntityId())) {
            return __('Standard');
        }

        return __('Easy Return');
    }
}
