<?php

namespace FiloBlu\Rma\Ui\Component\Listing\Columns\Order;

use FiloBlu\Rma\Helper\EasyReturnHelper;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Rma\Model\RmaFactory;
use Magento\Sales\Api\Data\OrderInterfaceFactory;
use Magento\Ui\Component\Listing\Columns\Column;

class Type extends Column
{
    /**
     * @var OrderInterfaceFactory
     */
    protected $orderInterfaceFactory;
    /**
     * @var RmaFactory
     */
    protected $rmaFactory;
    /**
     * @var EasyReturnHelper
     */
    protected $easyReturnHelper;

    public function __construct(
        ContextInterface $context ,
        UiComponentFactory $uiComponentFactory ,
        OrderInterfaceFactory $orderInterfaceFactory ,
        RmaFactory $rmaFactory,
        EasyReturnHelper $easyReturnHelper,
        array $components = [] ,
        array $data = []
    )
    {
        parent::__construct($context , $uiComponentFactory , $components , $data);
        $this->orderInterfaceFactory = $orderInterfaceFactory;
        $this->rmaFactory = $rmaFactory;
        $this->easyReturnHelper = $easyReturnHelper;
    }

    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {

                $label = __('Normal');

                if ($item['payment_method'] === 'changesizepay') {
                    $label = __('Change Size');
                    $item[$this->getData('name')] = $label;
                    continue;
                }

                $item[$this->getData('name')] = $label;
            }
        }

        return $dataSource;
    }
}
